/*
 * Decompiled with CFR 0.152.
 */
package org.libvirt;

import org.libvirt.Connect;
import org.libvirt.LibvirtException;
import org.libvirt.jna.InterfacePointer;
import org.libvirt.jna.Libvirt;

public class Interface {
    public static int VIR_INTERFACE_XML_INACTIVE = 1;
    InterfacePointer VIP;
    private Connect virConnect;
    protected Libvirt libvirt;

    Interface(Connect connect, InterfacePointer interfacePointer) {
        this.virConnect = connect;
        this.VIP = interfacePointer;
        this.libvirt = connect.libvirt;
    }

    public int create() throws LibvirtException {
        int n = this.libvirt.virInterfaceCreate(this.VIP);
        this.processError();
        return n;
    }

    public int destroy() throws LibvirtException {
        int n = this.libvirt.virInterfaceDestroy(this.VIP);
        this.processError();
        return n;
    }

    public void finalize() throws LibvirtException {
        this.free();
    }

    public int free() throws LibvirtException {
        int n = 0;
        if (this.VIP != null) {
            n = this.libvirt.virInterfaceFree(this.VIP);
            this.processError();
            this.VIP = null;
        }
        return n;
    }

    public String getMACString() throws LibvirtException {
        String string = this.libvirt.virInterfaceGetMACString(this.VIP);
        this.processError();
        return string;
    }

    public String getName() throws LibvirtException {
        String string = this.libvirt.virInterfaceGetName(this.VIP);
        this.processError();
        return string;
    }

    public String getXMLDescription(int n) throws LibvirtException {
        String string = this.libvirt.virInterfaceGetXMLDesc(this.VIP, n);
        this.processError();
        return string;
    }

    public int isActive() throws LibvirtException {
        int n = this.libvirt.virInterfaceIsActive(this.VIP);
        this.processError();
        return n;
    }

    protected void processError() throws LibvirtException {
        this.virConnect.processError();
    }

    public int undefine() throws LibvirtException {
        int n = this.libvirt.virInterfaceUndefine(this.VIP);
        this.processError();
        return n;
    }
}

