/*
 * Decompiled with CFR 0.152.
 */
package org.libvirt;

import com.sun.jna.Native;
import com.sun.jna.ptr.IntByReference;
import org.libvirt.Connect;
import org.libvirt.LibvirtException;
import org.libvirt.jna.Libvirt;
import org.libvirt.jna.NetworkPointer;

public class Network {
    NetworkPointer VNP;
    protected Connect virConnect;
    protected Libvirt libvirt;

    Network(Connect connect, NetworkPointer networkPointer) {
        this.virConnect = connect;
        this.VNP = networkPointer;
        this.libvirt = connect.libvirt;
    }

    public void create() throws LibvirtException {
        this.libvirt.virNetworkCreate(this.VNP);
        this.processError();
    }

    public void destroy() throws LibvirtException {
        this.libvirt.virNetworkDestroy(this.VNP);
        this.processError();
    }

    public void finalize() throws LibvirtException {
        this.free();
    }

    public int free() throws LibvirtException {
        int n = 0;
        if (this.VNP != null) {
            n = this.libvirt.virNetworkFree(this.VNP);
            this.processError();
            this.VNP = null;
        }
        return n;
    }

    public boolean getAutostart() throws LibvirtException {
        IntByReference intByReference = new IntByReference();
        this.libvirt.virNetworkGetAutostart(this.VNP, intByReference);
        this.processError();
        return intByReference.getValue() != 0;
    }

    public String getBridgeName() throws LibvirtException {
        String string = this.libvirt.virNetworkGetBridgeName(this.VNP);
        this.processError();
        return string;
    }

    public Connect getConnect() {
        return this.virConnect;
    }

    public String getName() throws LibvirtException {
        String string = this.libvirt.virNetworkGetName(this.VNP);
        this.processError();
        return string;
    }

    public int[] getUUID() throws LibvirtException {
        byte[] byArray = new byte[16];
        int n = this.libvirt.virNetworkGetUUID(this.VNP, byArray);
        this.processError();
        int[] nArray = new int[]{};
        if (n == 0) {
            nArray = Connect.convertUUIDBytes(byArray);
        }
        return nArray;
    }

    public String getUUIDString() throws LibvirtException {
        byte[] byArray = new byte[37];
        int n = this.libvirt.virNetworkGetUUIDString(this.VNP, byArray);
        this.processError();
        String string = null;
        if (n == 0) {
            string = Native.toString((byte[])byArray);
        }
        return string;
    }

    public String getXMLDesc(int n) throws LibvirtException {
        String string = this.libvirt.virNetworkGetXMLDesc(this.VNP, n);
        this.processError();
        return string;
    }

    public int isActive() throws LibvirtException {
        int n = this.libvirt.virNetworkIsActive(this.VNP);
        this.processError();
        return n;
    }

    public int isPersistent() throws LibvirtException {
        int n = this.libvirt.virNetworkIsPersistent(this.VNP);
        this.processError();
        return n;
    }

    protected void processError() throws LibvirtException {
        this.virConnect.processError();
    }

    public void setAutostart(boolean bl) throws LibvirtException {
        int n = bl ? 1 : 0;
        this.libvirt.virNetworkSetAutostart(this.VNP, n);
        this.processError();
    }

    public void undefine() throws LibvirtException {
        this.libvirt.virNetworkUndefine(this.VNP);
        this.processError();
    }
}

