/*
 * Decompiled with CFR 0.152.
 */
package org.libvirt;

import com.sun.jna.Native;
import org.libvirt.Connect;
import org.libvirt.LibvirtException;
import org.libvirt.jna.Libvirt;
import org.libvirt.jna.NetworkFilterPointer;

public class NetworkFilter {
    NetworkFilterPointer NFP;
    private Connect virConnect;
    protected Libvirt libvirt;

    public NetworkFilter(Connect connect, NetworkFilterPointer networkFilterPointer) {
        this.NFP = networkFilterPointer;
        this.virConnect = connect;
        this.libvirt = connect.libvirt;
    }

    public void finalize() throws LibvirtException {
        this.free();
    }

    public int free() throws LibvirtException {
        int n = 0;
        if (this.NFP != null) {
            n = this.libvirt.virNWFilterFree(this.NFP);
            this.processError();
            this.NFP = null;
        }
        return n;
    }

    public String getName() throws LibvirtException {
        String string = this.libvirt.virNWFilterGetName(this.NFP);
        this.processError();
        return string;
    }

    public int[] getUUID() throws LibvirtException {
        byte[] byArray = new byte[16];
        int n = this.libvirt.virNWFilterGetUUID(this.NFP, byArray);
        this.processError();
        int[] nArray = new int[]{};
        if (n == 0) {
            nArray = Connect.convertUUIDBytes(byArray);
        }
        return nArray;
    }

    public String getUUIDString() throws LibvirtException {
        byte[] byArray = new byte[37];
        int n = this.libvirt.virNWFilterGetUUIDString(this.NFP, byArray);
        this.processError();
        String string = null;
        if (n == 0) {
            string = Native.toString((byte[])byArray);
        }
        return string;
    }

    public String getXMLDesc() throws LibvirtException {
        String string = this.libvirt.virNWFilterGetXMLDesc(this.NFP, 0);
        this.processError();
        return string;
    }

    protected void processError() throws LibvirtException {
        this.virConnect.processError();
    }

    public void undefine() throws LibvirtException {
        this.libvirt.virNWFilterUndefine(this.NFP);
        this.processError();
    }
}

