/*
 * Decompiled with CFR 0.152.
 */
package org.libvirt;

import com.sun.jna.Native;
import java.util.Arrays;
import org.libvirt.SchedBooleanParameter;
import org.libvirt.SchedDoubleParameter;
import org.libvirt.SchedIntParameter;
import org.libvirt.SchedLongParameter;
import org.libvirt.SchedUintParameter;
import org.libvirt.SchedUlongParameter;
import org.libvirt.jna.virSchedParameter;
import org.libvirt.jna.virSchedParameterValue;

public abstract class SchedParameter {
    public String field;

    public static SchedParameter create(virSchedParameter virSchedParameter2) {
        SchedParameter schedParameter = null;
        if (virSchedParameter2 != null) {
            switch (virSchedParameter2.type) {
                case 1: {
                    schedParameter = new SchedIntParameter(virSchedParameter2.value.i);
                    break;
                }
                case 2: {
                    schedParameter = new SchedUintParameter(virSchedParameter2.value.ui);
                    break;
                }
                case 3: {
                    schedParameter = new SchedLongParameter(virSchedParameter2.value.l);
                    break;
                }
                case 4: {
                    schedParameter = new SchedUlongParameter(virSchedParameter2.value.ul);
                    break;
                }
                case 5: {
                    schedParameter = new SchedDoubleParameter(virSchedParameter2.value.d);
                    break;
                }
                case 6: {
                    schedParameter = new SchedBooleanParameter(virSchedParameter2.value.b);
                }
            }
            schedParameter.field = Native.toString((byte[])virSchedParameter2.field);
        }
        return schedParameter;
    }

    public static virSchedParameter toNative(SchedParameter schedParameter) {
        virSchedParameter virSchedParameter2 = new virSchedParameter();
        virSchedParameter2.value = new virSchedParameterValue();
        virSchedParameter2.field = Arrays.copyOf(schedParameter.field.getBytes(), 80);
        virSchedParameter2.type = schedParameter.getType();
        switch (schedParameter.getType()) {
            case 1: {
                virSchedParameter2.value.i = ((SchedIntParameter)schedParameter).value;
                break;
            }
            case 2: {
                virSchedParameter2.value.ui = ((SchedUintParameter)schedParameter).value;
                break;
            }
            case 3: {
                virSchedParameter2.value.l = ((SchedLongParameter)schedParameter).value;
                break;
            }
            case 4: {
                virSchedParameter2.value.ul = ((SchedUlongParameter)schedParameter).value;
                break;
            }
            case 5: {
                virSchedParameter2.value.d = ((SchedDoubleParameter)schedParameter).value;
                break;
            }
            case 6: {
                virSchedParameter2.value.b = (byte)(((SchedBooleanParameter)schedParameter).value ? 1 : 0);
            }
        }
        return virSchedParameter2;
    }

    public abstract int getType();

    public abstract String getTypeAsString();

    public abstract String getValueAsString();
}

