/*
 * Decompiled with CFR 0.152.
 */
package org.libvirt;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import org.libvirt.Connect;
import org.libvirt.LibvirtException;
import org.libvirt.jna.Libvirt;
import org.libvirt.jna.SecretPointer;

public class Secret {
    SecretPointer VSP;
    private Connect virConnect;
    protected Libvirt libvirt;

    Secret(Connect connect, SecretPointer secretPointer) {
        this.virConnect = connect;
        this.VSP = secretPointer;
        this.libvirt = connect.libvirt;
    }

    public void finalize() throws LibvirtException {
        this.free();
    }

    public int free() throws LibvirtException {
        int n = 0;
        if (this.VSP != null) {
            n = this.libvirt.virSecretFree(this.VSP);
            this.processError();
            this.VSP = null;
        }
        return n;
    }

    public String getUsageID() throws LibvirtException {
        String string = this.libvirt.virSecretGetUsageID(this.VSP);
        this.processError();
        return string;
    }

    public int[] getUUID() throws LibvirtException {
        byte[] byArray = new byte[16];
        int n = this.libvirt.virSecretGetUUID(this.VSP, byArray);
        this.processError();
        int[] nArray = new int[]{};
        if (n == 0) {
            nArray = Connect.convertUUIDBytes(byArray);
        }
        return nArray;
    }

    public String getUUIDString() throws LibvirtException {
        byte[] byArray = new byte[37];
        int n = this.libvirt.virSecretGetUUIDString(this.VSP, byArray);
        this.processError();
        String string = null;
        if (n == 0) {
            string = Native.toString((byte[])byArray);
        }
        return string;
    }

    public String getValue() throws LibvirtException {
        String string = this.libvirt.virSecretGetValue(this.VSP, new NativeLong(), 0);
        this.processError();
        return string;
    }

    public String getXMLDesc() throws LibvirtException {
        String string = this.libvirt.virSecretGetXMLDesc(this.VSP, 0);
        this.processError();
        return string;
    }

    protected void processError() throws LibvirtException {
        this.virConnect.processError();
    }

    public int setValue(String string) throws LibvirtException {
        int n = this.libvirt.virSecretSetValue(this.VSP, string, new NativeLong((long)string.length()), 0);
        this.processError();
        return n;
    }

    public int undefine() throws LibvirtException {
        int n = this.libvirt.virSecretUndefine(this.VSP);
        this.processError();
        return n;
    }
}

