/*
 * Decompiled with CFR 0.152.
 */
package org.libvirt;

import com.sun.jna.Native;
import com.sun.jna.ptr.IntByReference;
import org.libvirt.Connect;
import org.libvirt.LibvirtException;
import org.libvirt.StoragePoolInfo;
import org.libvirt.StorageVol;
import org.libvirt.jna.Libvirt;
import org.libvirt.jna.StoragePoolPointer;
import org.libvirt.jna.StorageVolPointer;
import org.libvirt.jna.virStoragePoolInfo;

public class StoragePool {
    protected StoragePoolPointer VSPP;
    protected Connect virConnect;
    protected Libvirt libvirt;

    StoragePool(Connect connect, StoragePoolPointer storagePoolPointer) {
        this.virConnect = connect;
        this.VSPP = storagePoolPointer;
        this.libvirt = connect.libvirt;
    }

    public void build(int n) throws LibvirtException {
        this.libvirt.virStoragePoolBuild(this.VSPP, n);
        this.processError();
    }

    public void create(int n) throws LibvirtException {
        this.libvirt.virStoragePoolCreate(this.VSPP, n);
        this.processError();
    }

    public void delete(int n) throws LibvirtException {
        this.libvirt.virStoragePoolDelete(this.VSPP, n);
        this.processError();
    }

    public void destroy() throws LibvirtException {
        this.libvirt.virStoragePoolDestroy(this.VSPP);
        this.processError();
    }

    public void finalize() throws LibvirtException {
        this.free();
    }

    public int free() throws LibvirtException {
        int n = 0;
        if (this.VSPP != null) {
            n = this.libvirt.virStoragePoolFree(this.VSPP);
            this.processError();
            this.VSPP = null;
        }
        return n;
    }

    public boolean getAutostart() throws LibvirtException {
        IntByReference intByReference = new IntByReference();
        this.libvirt.virStoragePoolGetAutostart(this.VSPP, intByReference);
        this.processError();
        return intByReference.getValue() != 0;
    }

    public Connect getConnect() {
        return this.virConnect;
    }

    public StoragePoolInfo getInfo() throws LibvirtException {
        virStoragePoolInfo virStoragePoolInfo2 = new virStoragePoolInfo();
        this.libvirt.virStoragePoolGetInfo(this.VSPP, virStoragePoolInfo2);
        this.processError();
        return new StoragePoolInfo(virStoragePoolInfo2);
    }

    public String getName() throws LibvirtException {
        String string = this.libvirt.virStoragePoolGetName(this.VSPP);
        this.processError();
        return string;
    }

    public int[] getUUID() throws LibvirtException {
        byte[] byArray = new byte[16];
        int n = this.libvirt.virStoragePoolGetUUID(this.VSPP, byArray);
        this.processError();
        int[] nArray = new int[]{};
        if (n == 0) {
            nArray = Connect.convertUUIDBytes(byArray);
        }
        return nArray;
    }

    public String getUUIDString() throws LibvirtException {
        byte[] byArray = new byte[37];
        int n = this.libvirt.virStoragePoolGetUUIDString(this.VSPP, byArray);
        this.processError();
        String string = null;
        if (n == 0) {
            string = Native.toString((byte[])byArray);
        }
        return string;
    }

    public String getXMLDesc(int n) throws LibvirtException {
        String string = this.libvirt.virStoragePoolGetXMLDesc(this.VSPP, n);
        this.processError();
        return string;
    }

    public int isActive() throws LibvirtException {
        int n = this.libvirt.virStoragePoolIsActive(this.VSPP);
        this.processError();
        return n;
    }

    public int isPersistent() throws LibvirtException {
        int n = this.libvirt.virStoragePoolIsPersistent(this.VSPP);
        this.processError();
        return n;
    }

    public String[] listVolumes() throws LibvirtException {
        int n = this.numOfVolumes();
        String[] stringArray = new String[n];
        this.libvirt.virStoragePoolListVolumes(this.VSPP, stringArray, n);
        this.processError();
        return stringArray;
    }

    public int numOfVolumes() throws LibvirtException {
        int n = this.libvirt.virStoragePoolNumOfVolumes(this.VSPP);
        this.processError();
        return n;
    }

    protected void processError() throws LibvirtException {
        this.virConnect.processError();
    }

    public void refresh(int n) throws LibvirtException {
        this.libvirt.virStoragePoolRefresh(this.VSPP);
        this.processError();
    }

    public void setAutostart(int n) throws LibvirtException {
        this.libvirt.virStoragePoolSetAutostart(this.VSPP, n);
    }

    public StorageVol storageVolCreateXML(String string, int n) throws LibvirtException {
        StorageVolPointer storageVolPointer = this.libvirt.virStorageVolCreateXML(this.VSPP, string, n);
        this.processError();
        return new StorageVol(this.virConnect, storageVolPointer);
    }

    public StorageVol storageVolCreateXMLFrom(String string, StorageVol storageVol, int n) throws LibvirtException {
        StorageVolPointer storageVolPointer = this.libvirt.virStorageVolCreateXMLFrom(this.VSPP, string, storageVol.VSVP, n);
        this.processError();
        return new StorageVol(this.virConnect, storageVolPointer);
    }

    public StorageVol storageVolLookupByName(String string) throws LibvirtException {
        StorageVolPointer storageVolPointer = this.libvirt.virStorageVolLookupByName(this.VSPP, string);
        this.processError();
        return new StorageVol(this.virConnect, storageVolPointer);
    }

    public void undefine() throws LibvirtException {
        this.libvirt.virStoragePoolUndefine(this.VSPP);
        this.processError();
    }

    static final class DeleteFlags {
        static final int VIR_STORAGE_POOL_DELETE_NORMAL = 0;
        static final int VIR_STORAGE_POOL_DELETE_ZEROED = 1;

        DeleteFlags() {
        }
    }

    static final class BuildFlags {
        static final int VIR_STORAGE_POOL_BUILD_NEW = 0;
        static final int VIR_STORAGE_POOL_BUILD_REPAIR = 1;
        static final int VIR_STORAGE_POOL_BUILD_RESIZE = 2;

        BuildFlags() {
        }
    }
}

