/*
 * Decompiled with CFR 0.152.
 */
package org.libvirt;

import org.libvirt.Connect;
import org.libvirt.LibvirtException;
import org.libvirt.StoragePool;
import org.libvirt.StorageVolInfo;
import org.libvirt.jna.Libvirt;
import org.libvirt.jna.StoragePoolPointer;
import org.libvirt.jna.StorageVolPointer;
import org.libvirt.jna.virStorageVolInfo;

public class StorageVol {
    StorageVolPointer VSVP;
    protected Connect virConnect;
    protected Libvirt libvirt;

    StorageVol(Connect connect, StorageVolPointer storageVolPointer) {
        this.virConnect = connect;
        this.VSVP = storageVolPointer;
        this.libvirt = connect.libvirt;
    }

    public void delete(int n) throws LibvirtException {
        this.libvirt.virStorageVolDelete(this.VSVP, n);
        this.processError();
    }

    public void finalize() throws LibvirtException {
        this.free();
    }

    public int free() throws LibvirtException {
        int n = 0;
        if (this.VSVP != null) {
            this.libvirt.virStorageVolFree(this.VSVP);
            this.processError();
            this.VSVP = null;
        }
        return n;
    }

    public Connect getConnect() {
        return this.virConnect;
    }

    public StorageVolInfo getInfo() throws LibvirtException {
        virStorageVolInfo virStorageVolInfo2 = new virStorageVolInfo();
        this.libvirt.virStorageVolGetInfo(this.VSVP, virStorageVolInfo2);
        this.processError();
        return new StorageVolInfo(virStorageVolInfo2);
    }

    public String getKey() throws LibvirtException {
        String string = this.libvirt.virStorageVolGetKey(this.VSVP);
        this.processError();
        return string;
    }

    public String getName() throws LibvirtException {
        String string = this.libvirt.virStorageVolGetName(this.VSVP);
        this.processError();
        return string;
    }

    public String getPath() throws LibvirtException {
        String string = this.libvirt.virStorageVolGetPath(this.VSVP);
        this.processError();
        return string;
    }

    public String getXMLDesc(int n) throws LibvirtException {
        String string = this.libvirt.virStorageVolGetXMLDesc(this.VSVP, n);
        this.processError();
        return string;
    }

    protected void processError() throws LibvirtException {
        this.virConnect.processError();
    }

    public StoragePool storagePoolLookupByVolume() throws LibvirtException {
        StoragePoolPointer storagePoolPointer = this.libvirt.virStoragePoolLookupByVolume(this.VSVP);
        this.processError();
        return new StoragePool(this.virConnect, storagePoolPointer);
    }

    public int wipe() throws LibvirtException {
        int n = this.libvirt.virStorageVolWipe(this.VSVP, 0);
        this.processError();
        return n;
    }

    public static enum Type {
        VIR_STORAGE_VOL_FILE,
        VIR_STORAGE_VOL_BLOCK;

    }

    static final class DeleteFlags {
        static final int VIR_STORAGE_POOL_DELETE_NORMAL = 0;
        static final int VIR_STORAGE_POOL_DELETE_ZEROED = 1;

        DeleteFlags() {
        }
    }
}

