/*
 * Decompiled with CFR 0.152.
 */
package org.libvirt;

import com.sun.jna.NativeLong;
import org.libvirt.Connect;
import org.libvirt.LibvirtException;
import org.libvirt.jna.Libvirt;
import org.libvirt.jna.StreamPointer;

public class Stream {
    public static int VIR_STREAM_NONBLOCK = 1;
    StreamPointer VSP;
    private Connect virConnect;
    protected Libvirt libvirt;

    Stream(Connect connect, StreamPointer streamPointer) {
        this.virConnect = connect;
        this.VSP = streamPointer;
        this.libvirt = connect.libvirt;
    }

    public int abort() throws LibvirtException {
        int n = this.libvirt.virStreamAbort(this.VSP);
        this.processError();
        return n;
    }

    public int addCallback(int n, Libvirt.VirStreamEventCallback virStreamEventCallback) throws LibvirtException {
        int n2 = this.libvirt.virStreamEventAddCallback(this.VSP, n, virStreamEventCallback, null, null);
        this.processError();
        return n2;
    }

    public void finalize() throws LibvirtException {
        this.free();
    }

    public int finish() throws LibvirtException {
        int n = this.libvirt.virStreamFinish(this.VSP);
        this.processError();
        return n;
    }

    public int free() throws LibvirtException {
        int n = 0;
        if (this.VSP != null) {
            n = this.libvirt.virStreamFree(this.VSP);
            this.processError();
            this.VSP = null;
        }
        return n;
    }

    protected void processError() throws LibvirtException {
        this.virConnect.processError();
    }

    public int receive(byte[] byArray) throws LibvirtException {
        int n = this.libvirt.virStreamRecv(this.VSP, byArray, new NativeLong((long)byArray.length));
        this.processError();
        return n;
    }

    public int receiveAll(Libvirt.VirStreamSinkFunc virStreamSinkFunc) throws LibvirtException {
        int n = this.libvirt.virStreamRecvAll(this.VSP, virStreamSinkFunc, null);
        this.processError();
        return n;
    }

    public int removeCallback() throws LibvirtException {
        int n = this.libvirt.virStreamEventRemoveCallback(this.VSP);
        this.processError();
        return n;
    }

    public int send(String string) throws LibvirtException {
        int n = this.libvirt.virStreamSend(this.VSP, string, new NativeLong((long)string.length()));
        this.processError();
        return n;
    }

    public int sendAll(Libvirt.VirStreamSourceFunc virStreamSourceFunc) throws LibvirtException {
        int n = this.libvirt.virStreamSendAll(this.VSP, virStreamSourceFunc, null);
        this.processError();
        return n;
    }

    public int updateCallback(int n) throws LibvirtException {
        int n2 = this.libvirt.virStreamEventUpdateCallback(this.VSP, n);
        this.processError();
        return n2;
    }
}

