/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.domain;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.management.ObjectName;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.domain.Domain;
import org.ow2.jasmine.vmm.agent.domain.ServerPool;
import org.ow2.jasmine.vmm.agent.driver.Driver;
import org.ow2.jasmine.vmm.agent.driver.DriverFactory;
import org.ow2.jasmine.vmm.agent.jmx.MBeanObjectNamer;
import org.ow2.jasmine.vmm.agent.main.AgentCommon;
import org.ow2.jasmine.vmm.api.VMMException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class DomainBuilder {
    static Logger logger = Logger.getLogger(DomainBuilder.class);

    private static Map<String, String> attributes2Map(Attributes attrs) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < attrs.getLength(); ++i) {
            String name = attrs.getLocalName(i);
            String val = attrs.getValue(i);
            map.put(name, val);
        }
        return map;
    }

    public static Domain createManagedResourcesFromXML(File file) {
        try {
            DomainXMLHandler handler = new DomainXMLHandler();
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            logger.info((Object)("Reading resource description file " + file.getAbsolutePath()));
            parser.parse((InputStream)new FileInputStream(file), (DefaultHandler)handler);
            return handler.rootDomain;
        }
        catch (Exception ex) {
            logger.error((Object)"While parsing resource description file:", (Throwable)ex);
            return null;
        }
    }

    static class DomainXMLHandler
    extends DefaultHandler {
        Stack<Domain> domainStack = new Stack();
        Domain rootDomain;
        Domain currentDomain;
        ServerPool currentServerPool;
        StringBuffer currentPath = new StringBuffer();

        DomainXMLHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) {
            if (qName.equals("domain")) {
                String name = attrs.getValue("name");
                if (name == null) {
                    logger.error((Object)"Missing domain name, skipping domain definition");
                    this.currentDomain = null;
                    return;
                }
                this.currentPath.append("/" + name);
                ObjectName domainObjectName = MBeanObjectNamer.makeDomainName(this.currentPath.toString());
                Domain domain = new Domain(name, domainObjectName, DomainBuilder.attributes2Map(attrs));
                try {
                    AgentCommon.getMBeanServer().registerMBean(domain, domainObjectName);
                }
                catch (Exception ex) {
                    logger.error((Object)("Skipping domain " + name), (Throwable)ex);
                    this.currentDomain = null;
                    return;
                }
                logger.info((Object)("Added Domain " + domainObjectName));
                if (this.domainStack.isEmpty()) {
                    this.rootDomain = domain;
                } else {
                    this.domainStack.peek().addSubDomain(domain);
                }
                this.domainStack.push(domain);
                this.currentDomain = domain;
            } else if (qName.equals("serverPool")) {
                if (this.currentDomain != null) {
                    String name = attrs.getValue("name");
                    String driverName = attrs.getValue("driver");
                    if (name == null) {
                        logger.error((Object)"skipped server pool because of missing name");
                        return;
                    }
                    if (driverName == null) {
                        logger.error((Object)"skipped server pool because of missing driver name");
                        return;
                    }
                    ObjectName serverPoolObjectName = null;
                    serverPoolObjectName = MBeanObjectNamer.makeServerPoolName(this.currentPath.toString() + "/" + name);
                    Driver driver = DriverFactory.getInstance().newDriver(driverName);
                    if (driver != null) {
                        try {
                            this.currentServerPool = driver.newServerPool(name, serverPoolObjectName, DomainBuilder.attributes2Map(attrs));
                        }
                        catch (IllegalArgumentException ex) {
                            logger.error((Object)("Skipping ServerPool " + name + ":" + ex.getMessage()));
                            this.currentServerPool = null;
                            return;
                        }
                        catch (VMMException ex) {
                            logger.error((Object)("Skipping ServerPool " + name + ":" + ex.getMessage()));
                            this.currentServerPool = null;
                            return;
                        }
                        try {
                            AgentCommon.getMBeanServer().registerMBean(this.currentServerPool, serverPoolObjectName);
                        }
                        catch (Exception ex) {
                            logger.error((Object)("Skipping ServerPool " + name), (Throwable)ex);
                            this.currentServerPool = null;
                            return;
                        }
                        logger.info((Object)("Added ServerPool " + serverPoolObjectName));
                        this.currentDomain.addServerPool(this.currentServerPool);
                    } else {
                        logger.error((Object)("Driver " + driverName + " not found"));
                        this.currentServerPool = null;
                    }
                }
            } else if (qName.equals("host")) {
                String hostName = attrs.getValue("name");
                if (hostName == null) {
                    logger.error((Object)"Missing host name, skipping host definition");
                    return;
                }
                if (this.currentServerPool != null) {
                    try {
                        this.currentServerPool.newHost(hostName, DomainBuilder.attributes2Map(attrs));
                    }
                    catch (VMMException ex) {
                        logger.error((Object)("Skipping host " + hostName + ":" + ex.getMessage()));
                    }
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("domain")) {
                if (this.currentDomain != null) {
                    this.domainStack.pop();
                    this.currentPath.delete(this.currentPath.lastIndexOf("/"), this.currentPath.length());
                }
                this.currentDomain = this.domainStack.isEmpty() ? null : this.domainStack.peek();
            } else if (qName.equals("serverPool")) {
                this.currentServerPool = null;
            }
        }
    }
}

