/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.dummy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.domain.AbstractHost;
import org.ow2.jasmine.vmm.agent.driver.dummy.DummyServerPool;
import org.ow2.jasmine.vmm.agent.driver.dummy.DummyVirtualMachine;
import org.ow2.jasmine.vmm.agent.driver.util.ResourceUsageHelper;
import org.ow2.jasmine.vmm.agent.jmx.MBeanObjectNamer;
import org.ow2.jasmine.vmm.agent.main.AgentCommon;
import org.ow2.jasmine.vmm.api.HostMXBean;
import org.ow2.jasmine.vmm.api.InsufficientResourcesException;
import org.ow2.jasmine.vmm.api.InvalidVMConfigException;
import org.ow2.jasmine.vmm.api.ResourceUsage;
import org.ow2.jasmine.vmm.api.ServerPoolMXBean;
import org.ow2.jasmine.vmm.api.VMConfigSpec;
import org.ow2.jasmine.vmm.api.VMCustomizationSpec;
import org.ow2.jasmine.vmm.api.VMMException;
import org.ow2.jasmine.vmm.api.VirtualMachineImageStoreMXBean;
import org.ow2.jasmine.vmm.api.VirtualMachineMXBean;

class DummyHost
extends AbstractHost {
    static Logger logger = Logger.getLogger(DummyHost.class);
    private List<DummyVirtualMachine> vms = new CopyOnWriteArrayList<DummyVirtualMachine>();
    private static ExecutorService executorService = Executors.newFixedThreadPool(3);
    private Timer perfTimer;
    private String hostName;
    private final ObjectName objectName;
    private HostMXBean.HostPowerState hostPowerState = HostMXBean.HostPowerState.UNKNOWN;
    private int numCPU = 4;
    private int totalMemoryMB;
    private int freeMemoryMB;
    private int cpuCapacityMHz;
    private DummyServerPool pool;
    private static Random rand = new Random(System.currentTimeMillis());
    HashMap<String, String> hypervisorInfo;
    HashMap<String, String> cpuInfo;
    private Set<HostMXBean.PerfMetric> currentMonitoredMetrics;
    private long currentMonitoringPeriod = 1000L;

    public DummyHost(DummyServerPool pool, String hostName, ObjectName objectName, Boolean active) {
        super(objectName);
        this.pool = pool;
        this.hostName = hostName;
        this.objectName = objectName;
        this.hostPowerState = HostMXBean.HostPowerState.RUNNING;
        if (rand.nextInt() % 2 == 0) {
            this.freeMemoryMB = 4096;
            this.totalMemoryMB = 4096;
            this.cpuCapacityMHz = 1000;
        } else {
            this.freeMemoryMB = 8192;
            this.totalMemoryMB = 8192;
            this.cpuCapacityMHz = 2300;
        }
        this.startPerfMonitor();
    }

    @Override
    public boolean isConnectionLost() {
        return false;
    }

    @Override
    public ServerPoolMXBean getServerPool() {
        return this.pool;
    }

    private void addVM(DummyVirtualMachine vm) {
        this.vms.add(vm);
    }

    private void removeVM(DummyVirtualMachine vm) {
        this.vms.remove(vm);
    }

    void postMigrateVM(DummyVirtualMachine vm, DummyHost newHost) {
        this.removeVM(vm);
        newHost.addVM(vm);
        this.freeMemoryMB = (int)((long)this.freeMemoryMB + vm.getMemorySizeMB());
        newHost.freeMemoryMB = (int)((long)newHost.freeMemoryMB - vm.getMemorySizeMB());
    }

    public void postDestroyVM(DummyVirtualMachine vm) {
        this.removeVM(vm);
        this.freeMemoryMB = (int)((long)this.freeMemoryMB + vm.getMemorySizeMB());
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    public synchronized void onDestroyVM(DummyVirtualMachine vm) {
        try {
            AgentCommon.getMBeanServer().unregisterMBean(vm.getObjectName());
        }
        catch (Exception ex) {
            logger.error((Object)"Cannot unregister VM MBean", (Throwable)ex);
        }
        this.removeVM(vm);
        this.freeMemoryMB = (int)((long)this.freeMemoryMB + vm.getMemorySizeMB());
        ((DummyServerPool.DummyVirtualMachineImageStore)this.pool.getVMImageStore()).updateFreeSpace(vm.getDiskSizeMB());
        this.emitNotification("vm.del", "Destroyed", vm.getObjectName());
        logger.info((Object)("destroyed VM " + vm.getObjectName()));
    }

    public synchronized void removeVMFromInventory(DummyVirtualMachine vm) {
        try {
            AgentCommon.getMBeanServer().unregisterMBean(vm.getObjectName());
        }
        catch (Exception ex) {
            logger.error((Object)"Cannot unregister VM MBean", (Throwable)ex);
        }
        this.removeVM(vm);
        this.emitNotification("vm.inventory.del", "Deleted", vm.getObjectName());
        logger.info((Object)("deleted VM " + vm.getObjectName()));
    }

    @Override
    public VirtualMachineMXBean createVM(VMConfigSpec vmSpec, boolean sync) throws InsufficientResourcesException, InvalidVMConfigException, VMMException {
        final VMConfigSpec vmSpec2 = new VMConfigSpec(vmSpec);
        for (DummyVirtualMachine dvm : this.vms) {
            if (!dvm.getNameLabel().equals(vmSpec2.getName())) continue;
            throw new InvalidVMConfigException("VM name already exists");
        }
        if (vmSpec2.getMemorySizeMB() > this.getFreeMemoryMB()) {
            throw new InsufficientResourcesException();
        }
        if (!sync) {
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        DummyHost.this.createVM2(vmSpec2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            return null;
        }
        return this.createVM2(vmSpec2);
    }

    private VirtualMachineMXBean createVM2(VMConfigSpec vmSpec) throws InsufficientResourcesException, InvalidVMConfigException, VMMException {
        DummyVirtualMachine vm = null;
        try {
            Thread.sleep(5000L);
            Random random = new Random(System.currentTimeMillis());
            String uuid = Integer.toString(random.nextInt(10000));
            ObjectName vmName = MBeanObjectNamer.makeVirtualMachineName(this.getServerPool().getPath() + "/" + vmSpec.getName(), uuid);
            vm = new DummyVirtualMachine(vmSpec.getName(), uuid, vmName, this);
            this.addVM(vm);
            vm.setDiskSizeMB(vmSpec.getDiskSizeMB());
            vm.setNumVCPUs(vmSpec.getNumVCPU());
            vm.setMemorySizeMB((int)vmSpec.getMemorySizeMB());
            vm.addUserData("imageID", vmSpec.getVmImageUUID());
            AgentCommon.getMBeanServer().registerMBean(vm, vm.getObjectName());
            logger.info((Object)("VM Creation: registered VirtualMachineMBean " + vm.getObjectName()));
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to create VM", (Throwable)ex);
            return null;
        }
        this.emitNotification("vm.add", "Created", vm.getObjectName());
        this.freeMemoryMB = (int)((long)this.freeMemoryMB - vmSpec.getMemorySizeMB());
        ((DummyServerPool.DummyVirtualMachineImageStore)this.pool.getVMImageStore()).updateFreeSpace(-vmSpec.getDiskSizeMB());
        return vm;
    }

    public VirtualMachineMXBean cloneVM(final DummyVirtualMachine sourceVM, final String clonedVMName, final VMCustomizationSpec custSpec, boolean sync) throws InsufficientResourcesException, InvalidVMConfigException, VMMException {
        for (DummyVirtualMachine dvm : this.vms) {
            if (!dvm.getNameLabel().equals(clonedVMName)) continue;
            throw new InvalidVMConfigException("VM name already exists");
        }
        if (!sync) {
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        DummyHost.this.cloneVM2(sourceVM, clonedVMName, custSpec);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            return null;
        }
        return this.cloneVM2(sourceVM, clonedVMName, custSpec);
    }

    private VirtualMachineMXBean cloneVM2(DummyVirtualMachine sourceVM, String clonedVMName, VMCustomizationSpec custSpec) throws InsufficientResourcesException, InvalidVMConfigException, VMMException {
        DummyVirtualMachine vm = null;
        try {
            Thread.sleep(5000L);
            Random random = new Random(System.currentTimeMillis());
            String uuid = Integer.toString(random.nextInt(10000));
            ObjectName vmName = MBeanObjectNamer.makeVirtualMachineName(this.getServerPool().getPath() + "/" + clonedVMName, uuid);
            vm = new DummyVirtualMachine(clonedVMName, uuid, vmName, this);
            this.addVM(vm);
            vm.setDiskSizeMB(sourceVM.getDiskSizeMB());
            vm.setNumVCPUs(sourceVM.getNumVCPUs());
            vm.setMemorySizeMB((int)sourceVM.getMemorySizeMB());
            AgentCommon.getMBeanServer().registerMBean(vm, vm.getObjectName());
            logger.info((Object)("VM Cloning: registered VirtualMachineMBean " + vm.getObjectName()));
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to clone VM", (Throwable)ex);
            return null;
        }
        this.emitNotification("vm.add", "Created", vm.getObjectName());
        this.freeMemoryMB = (int)((long)this.freeMemoryMB - sourceVM.getMemorySizeMB());
        ((DummyServerPool.DummyVirtualMachineImageStore)this.pool.getVMImageStore()).updateFreeSpace(-sourceVM.getDiskSizeMB());
        return vm;
    }

    @Override
    public Map<String, String> getHypervisorInfo() {
        if (this.hypervisorInfo == null) {
            this.hypervisorInfo = new HashMap();
            this.hypervisorInfo.put("name", "DummyHypervisor");
            this.hypervisorInfo.put("vendor", "");
            this.hypervisorInfo.put("version", "1.0");
        }
        return this.hypervisorInfo;
    }

    @Override
    public Map<String, String> getCPUInfo() {
        if (this.cpuInfo == null) {
            this.cpuInfo = new HashMap();
            this.cpuInfo.put("model", "Core 2 Duo");
            this.cpuInfo.put("speedMHz", Integer.toString(this.cpuCapacityMHz));
            this.cpuInfo.put("vendor", "Intel");
        }
        return this.cpuInfo;
    }

    @Override
    public int getNumCPU() {
        return this.numCPU;
    }

    @Override
    public float[] getLoadPerCPU() {
        return new float[]{0.0f, 0.0f};
    }

    @Override
    public float getCPULoad() {
        float load = 0.0f;
        for (DummyVirtualMachine vm : this.vms) {
            load += vm.getCPULoad();
        }
        return Math.min(1.0f, load);
    }

    @Override
    public Map<String, Float> getVMCPULoads() {
        HashMap<String, Float> cpuLoads = new HashMap<String, Float>();
        for (DummyVirtualMachine vm : this.vms) {
            cpuLoads.put(vm.getNameLabel(), Float.valueOf(vm.getResourceUsage().getCpuLoad()));
        }
        return cpuLoads;
    }

    @Override
    public long getFreeMemoryMB() {
        return this.freeMemoryMB;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public List<VirtualMachineMXBean> getResidentVMs() {
        ArrayList<VirtualMachineMXBean> vmList = new ArrayList<VirtualMachineMXBean>();
        for (DummyVirtualMachine vm : this.vms) {
            vmList.add(vm);
        }
        return vmList;
    }

    @Override
    public long getTotalMemoryMB() {
        return this.totalMemoryMB;
    }

    @Override
    public VirtualMachineImageStoreMXBean getVMImageStore() {
        return this.pool.getVMImageStore();
    }

    public String getUUID() {
        return null;
    }

    @Override
    public Map<String, ResourceUsage> getVMResourceUsage() {
        HashMap<String, ResourceUsage> result = new HashMap<String, ResourceUsage>();
        for (DummyVirtualMachine vm : this.vms) {
            result.put(vm.getNameLabel(), vm.getResourceUsage());
        }
        return result;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"vm.state", "vm.add", "vm.del", "vm.inventory.del", "log", "vm.error", "host.perfreport"}, Notification.class.getName(), "Host event")};
    }

    @Override
    public void configurePerfMonitor(Set<HostMXBean.PerfMetric> metricsOfInterest, long periodMillis) {
        this.stopPerfMonitor();
        if (periodMillis < 1000L) {
            periodMillis = 1000L;
        }
        if (metricsOfInterest.contains((Object)HostMXBean.PerfMetric.VM_CPU_LOAD)) {
            this.currentMonitoringPeriod = periodMillis;
            this.currentMonitoredMetrics = metricsOfInterest;
            this.startPerfMonitor();
        }
    }

    private void startPerfMonitor() {
        if (this.perfTimer == null) {
            logger.info((Object)("Host " + this.hostName + ": starting periodic perf monitor task"));
            this.perfTimer = new Timer();
            this.perfTimer.schedule((TimerTask)new PerfTimerTask(), 0L, this.currentMonitoringPeriod);
        }
    }

    private void stopPerfMonitor() {
        if (this.perfTimer != null) {
            logger.info((Object)("Host " + this.hostName + ": stopping periodic perf monitor task"));
            this.perfTimer.cancel();
        }
        this.perfTimer = null;
    }

    @Override
    public Map<String, String> getAttributes() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("name", this.hostName);
        attributes.put("driver", "dummy");
        return attributes;
    }

    public String getDriver() {
        return "dummy";
    }

    @Override
    public void removeFromInventory() {
        while (this.getResidentVMs().size() > 0) {
            this.removeVMFromInventory((DummyVirtualMachine)this.getResidentVMs().get(0));
        }
    }

    @Override
    public void start() {
        this.startPerfMonitor();
        this.hostPowerState = HostMXBean.HostPowerState.RUNNING;
    }

    @Override
    public void stop() {
        while (this.getResidentVMs().size() > 0) {
            this.removeVMFromInventory((DummyVirtualMachine)this.getResidentVMs().get(0));
        }
        this.stopPerfMonitor();
        this.hostPowerState = HostMXBean.HostPowerState.HALTED;
    }

    @Override
    public HostMXBean.HostPowerState getHostState() throws VMMException {
        return this.hostPowerState;
    }

    private class PerfTimerTask
    extends TimerTask {
        private PerfTimerTask() {
        }

        @Override
        public void run() {
            HashMap<String, CompositeData> result = new HashMap<String, CompositeData>();
            try {
                float totalCpuLoad = 0.0f;
                for (DummyVirtualMachine vm : DummyHost.this.vms) {
                    vm.currentCpuLoad = (float)((double)vm.currentCpuLoad + ((double)rand.nextFloat() * 0.2 - 0.1));
                    if ((double)vm.currentCpuLoad <= 0.0) {
                        vm.currentCpuLoad = 0.0f;
                    } else if (vm.currentCpuLoad > 1.0f - totalCpuLoad) {
                        vm.currentCpuLoad = 1.0f - totalCpuLoad;
                    }
                    totalCpuLoad += vm.currentCpuLoad;
                    CompositeData cd = (CompositeData)ResourceUsageHelper.serialize(vm.getResourceUsage());
                    result.put(vm.getNameLabel(), cd);
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                return;
            }
            DummyHost.this.emitNotification("host.perfreport", "Resource Usage", result);
        }
    }
}

