/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.dummy;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.domain.ManagedResource;
import org.ow2.jasmine.vmm.agent.driver.dummy.DummyHost;
import org.ow2.jasmine.vmm.agent.driver.dummy.DummyServerPool;
import org.ow2.jasmine.vmm.api.BadVMPowerStateException;
import org.ow2.jasmine.vmm.api.HostMXBean;
import org.ow2.jasmine.vmm.api.IllegalOperationException;
import org.ow2.jasmine.vmm.api.InsufficientResourcesException;
import org.ow2.jasmine.vmm.api.ResourceUsage;
import org.ow2.jasmine.vmm.api.VMCustomizationSpec;
import org.ow2.jasmine.vmm.api.VMMException;
import org.ow2.jasmine.vmm.api.VirtualMachineImageMXBean;
import org.ow2.jasmine.vmm.api.VirtualMachineMXBean;

class DummyVirtualMachine
extends ManagedResource
implements VirtualMachineMXBean {
    static Logger logger = Logger.getLogger(DummyVirtualMachine.class);
    private String name;
    private DummyHost host;
    private String uuid;
    private String ipAddress;
    private int numVCPU;
    private int schedulingCap;
    private int schedulingWeight;
    private int diskSizeMB;
    private long memorySizeMB;
    private long memoryUsedMB;
    private VirtualMachineMXBean.PowerState status = VirtualMachineMXBean.PowerState.HALTED;
    private Date startTime;
    private boolean[][] cpuAffinity;
    Map<String, String> userData = new HashMap<String, String>();
    int count = 0;
    private ResourceUsage currentResourceUsage;
    Random rand = new Random(System.currentTimeMillis());
    float currentCpuLoad = 0.0f;

    public DummyVirtualMachine(String name, String uuid, ObjectName objectName, DummyHost host) {
        super(objectName);
        this.name = name;
        this.host = host;
        this.uuid = uuid;
        this.memorySizeMB = 8192L;
        this.startTime = new Date(System.currentTimeMillis());
        this.currentResourceUsage = new ResourceUsage();
        ArrayList<ResourceUsage.DiskStats> diskStats = new ArrayList<ResourceUsage.DiskStats>();
        diskStats.add(new ResourceUsage.DiskStats());
        ((ResourceUsage.DiskStats)diskStats.get(0)).setDeviceName("disk");
        ArrayList<ResourceUsage.NetworkStats> netStats = new ArrayList<ResourceUsage.NetworkStats>();
        netStats.add(new ResourceUsage.NetworkStats());
        ((ResourceUsage.NetworkStats)netStats.get(0)).setDeviceName("net");
        this.currentResourceUsage.setDiskStats(diskStats);
        this.currentResourceUsage.setNetworkStats(netStats);
        try {
            this.ipAddress = InetAddress.getByName("198.7.9.66").getHostAddress();
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to get IP address", (Throwable)ex);
        }
    }

    @Override
    public Date getStartTime() {
        return this.startTime;
    }

    public long getUpTimeSeconds() {
        return (System.currentTimeMillis() - this.startTime.getTime()) / 1000L;
    }

    @Override
    public int getNumVCPUs() {
        return this.numVCPU;
    }

    @Override
    public void setNumVCPUs(int numVCPU) {
        this.numVCPU = numVCPU;
    }

    public int getDiskSizeMB() {
        return this.diskSizeMB;
    }

    public void setDiskSizeMB(int diskSizeMB) {
        this.diskSizeMB = diskSizeMB;
    }

    @Override
    public long getMemorySizeMB() {
        return this.memorySizeMB;
    }

    @Override
    public long getMemoryUsedMB() {
        return this.memoryUsedMB;
    }

    @Override
    public void setMemorySizeMB(long memorySizeMB) {
        this.memorySizeMB = memorySizeMB;
        this.memoryUsedMB = memorySizeMB / 2L;
    }

    public void addUserData(String key, String value) {
        this.userData.put(key, value);
    }

    @Override
    public String getUserData(String key) {
        return this.userData.get(key);
    }

    @Override
    public String getConsole() {
        return null;
    }

    public void onVMStatusChanged() {
        logger.info((Object)("VM " + this.getNameLabel() + " state=" + (Object)((Object)this.getState())));
        this.emitNotification("vm.state", this.getState().toString(), null);
    }

    @Override
    public boolean canLiveMigrateToHost(HostMXBean targetHost) throws VMMException {
        return targetHost != this.host && this.getMemorySizeMB() <= targetHost.getFreeMemoryMB();
    }

    @Override
    public void destroy() {
        try {
            Thread.sleep(3000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.host.onDestroyVM(this);
    }

    @Override
    public float[] getLoadPerVCPU() {
        return new float[]{8.0f, 10.0f};
    }

    @Override
    public float getCPULoad() {
        if (this.status == VirtualMachineMXBean.PowerState.RUNNING) {
            return this.currentResourceUsage.getCpuLoad();
        }
        return 0.0f;
    }

    @Override
    public HostMXBean getHostMBean() {
        return this.host;
    }

    @Override
    public String getGuestIpAddress() {
        return this.ipAddress;
    }

    @Override
    public String getMacAddress() {
        return "8E:10:65:AB:CE:26";
    }

    public int getMemory() {
        return 0;
    }

    @Override
    public String getNameLabel() {
        return this.name;
    }

    @Override
    public int getSchedulingCap() {
        return this.schedulingCap;
    }

    @Override
    public int getSchedulingWeight() {
        return this.schedulingWeight;
    }

    @Override
    public VirtualMachineMXBean.PowerState getState() {
        return this.status;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public void reboot() {
        logger.info((Object)("Rebooting VM " + this.name));
    }

    @Override
    public void resume() {
        if (this.status == VirtualMachineMXBean.PowerState.SUSPENDED) {
            this.status = VirtualMachineMXBean.PowerState.RUNNING;
            this.onVMStatusChanged();
            logger.info((Object)("VM " + this.name + " resumed"));
        }
    }

    public void setMacAddress(String mac) {
    }

    @Override
    public void setSchedulingCap(int schedulingCap) {
        this.schedulingCap = schedulingCap;
    }

    @Override
    public void setSchedulingWeight(int schedulingWeight) {
        this.schedulingWeight = schedulingWeight;
    }

    @Override
    public boolean[][] getCPUAffinity() {
        if (this.cpuAffinity == null) {
            this.cpuAffinity = new boolean[this.numVCPU][];
            for (int i = 0; i < this.numVCPU; ++i) {
                this.cpuAffinity[i] = new boolean[this.host.getNumCPU()];
                for (int j = 0; j < this.host.getNumCPU(); ++j) {
                    this.cpuAffinity[i][j] = true;
                }
            }
        }
        return this.cpuAffinity;
    }

    @Override
    public void setCPUAffinity(boolean[][] affinity) {
        boolean[][] cpuAffinity = this.getCPUAffinity();
        for (int i = 0; i < this.numVCPU; ++i) {
            for (int j = 0; j < this.host.getNumCPU(); ++j) {
                this.cpuAffinity[i][j] = affinity[i][j];
            }
        }
    }

    @Override
    public void shutdown() {
        if (this.status == VirtualMachineMXBean.PowerState.RUNNING) {
            this.status = VirtualMachineMXBean.PowerState.HALTED;
            this.onVMStatusChanged();
            logger.info((Object)("VM " + this.name + " shutdowned"));
        }
    }

    @Override
    public void start() {
        if (this.status == VirtualMachineMXBean.PowerState.HALTED) {
            this.status = VirtualMachineMXBean.PowerState.RUNNING;
            this.onVMStatusChanged();
            logger.info((Object)("VM " + this.name + " started"));
        }
    }

    @Override
    public void suspend() throws BadVMPowerStateException {
        if (this.status == VirtualMachineMXBean.PowerState.RUNNING) {
            this.status = VirtualMachineMXBean.PowerState.SUSPENDED;
            this.onVMStatusChanged();
            logger.info((Object)("VM " + this.name + " suspended"));
        }
    }

    @Override
    public void pause() throws BadVMPowerStateException {
        if (this.status == VirtualMachineMXBean.PowerState.RUNNING) {
            this.status = VirtualMachineMXBean.PowerState.PAUSED;
            this.onVMStatusChanged();
            logger.info((Object)("VM " + this.name + " paused"));
        }
    }

    @Override
    public void unpause() throws BadVMPowerStateException {
        if (this.status == VirtualMachineMXBean.PowerState.PAUSED) {
            this.status = VirtualMachineMXBean.PowerState.RUNNING;
            this.onVMStatusChanged();
            logger.info((Object)("VM " + this.name + " unpaused"));
        }
    }

    @Override
    public void migrate(HostMXBean targetHost, boolean live) throws IllegalOperationException, VMMException {
        String targetHostName = targetHost.getHostName();
        boolean foundHostInServerPool = false;
        for (HostMXBean h : this.host.getServerPool().getManagedHosts()) {
            if (!h.getHostName().equals(targetHost.getHostName())) continue;
            foundHostInServerPool = true;
            targetHost = h;
            break;
        }
        if (targetHost.getFreeMemoryMB() < this.getMemorySizeMB()) {
            throw new VMMException("Not enough memory on target host");
        }
        if (!foundHostInServerPool) {
            throw new IllegalOperationException("Source and target hosts belong to different server pools");
        }
        this.emitNotification("vm.migration.start", targetHostName, this.uuid);
        try {
            Thread.sleep(1000L);
        }
        catch (Exception ex) {
            // empty catch block
        }
        DummyHost target = (DummyHost)targetHost;
        this.host.postMigrateVM(this, target);
        this.host = target;
        this.emitNotification("vm.migration", targetHostName, this.uuid);
    }

    @Override
    public VirtualMachineMXBean cloneVM(String name, VMCustomizationSpec custSpec, boolean sync) throws InsufficientResourcesException, VMMException {
        return this.host.cloneVM(this, name, custSpec, sync);
    }

    @Override
    public ResourceUsage getResourceUsage() {
        if (this.status == VirtualMachineMXBean.PowerState.RUNNING) {
            this.currentResourceUsage.setCpuLoad(this.currentCpuLoad);
            this.currentResourceUsage.setMemoryUsedKBytes(this.getMemoryUsedMB() * 1024L);
            this.currentResourceUsage.setSamplingTime(new Date(System.currentTimeMillis()));
            this.currentResourceUsage.getDiskStats().get(0).setDiskReadKBytePerSec(this.rand.nextInt(10));
            this.currentResourceUsage.getDiskStats().get(0).setDiskWrittenKBytesPerSec(this.rand.nextInt(10));
            this.currentResourceUsage.getNetworkStats().get(0).setNetReceivedKbitPerSec(this.rand.nextInt(10));
            this.currentResourceUsage.getNetworkStats().get(0).setNetTransmittedKbitPerSec(this.rand.nextInt(10));
        } else {
            this.currentResourceUsage.setCpuLoad(0.0f);
            this.currentResourceUsage.setMemoryUsedKBytes(0L);
            this.currentResourceUsage.setSamplingTime(new Date(System.currentTimeMillis()));
            this.currentResourceUsage.getDiskStats().get(0).setDiskReadKBytePerSec(0L);
            this.currentResourceUsage.getDiskStats().get(0).setDiskWrittenKBytesPerSec(0L);
            this.currentResourceUsage.getNetworkStats().get(0).setNetReceivedKbitPerSec(0L);
            this.currentResourceUsage.getNetworkStats().get(0).setNetTransmittedKbitPerSec(0L);
        }
        return this.currentResourceUsage;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"vm.state", "vm.migration", "log", "vm.error"}, Notification.class.getName(), "VM event")};
    }

    @Override
    public VirtualMachineImageMXBean makeTemplate(String name, String description, Map<String, String> metadata) throws InsufficientResourcesException, IllegalOperationException, BadVMPowerStateException, VMMException {
        try {
            Thread.sleep(15000L);
            return ((DummyServerPool.DummyVirtualMachineImageStore)this.host.getVMImageStore()).addImage(name, description, metadata);
        }
        catch (Exception ex) {
            throw new VMMException(ex);
        }
    }
}

