/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.hyperv;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.management.ObjectName;
import org.ow2.jasmine.vmm.agent.domain.ServerPool;
import org.ow2.jasmine.vmm.agent.driver.hyperv.HyperVConnection;
import org.ow2.jasmine.vmm.agent.driver.hyperv.HyperVEventCollector;
import org.ow2.jasmine.vmm.agent.driver.hyperv.HyperVHost;
import org.ow2.jasmine.vmm.agent.driver.hyperv.HyperVVMImageStore;
import org.ow2.jasmine.vmm.agent.jmx.MBeanObjectNamer;
import org.ow2.jasmine.vmm.agent.main.AgentCommon;
import org.ow2.jasmine.vmm.api.HostMXBean;
import org.ow2.jasmine.vmm.api.VMMException;
import org.ow2.jasmine.vmm.api.VirtualMachineImageStoreMXBean;

public class HyperVServerPool
extends ServerPool {
    public static int EVENT_COLLECTOR_PERIOD;
    public static boolean LEGACY_NETWORK_ADAPTER;
    public static final String LEGACY_NETWORK_NAME = "Legacy Network Adapter";
    public static final String SYNTHETIC_NETWORK_NAME = "VMBus Network Adapter";
    private static final int THREADPOOL_SIZE = 20;
    private static ExecutorService executorService;
    private HyperVEventCollector eventCollector;
    private String hypervUser;
    private String hypervPassword;
    private VirtualMachineImageStoreMXBean imageStore;
    private String vmFolder;
    private String vmTemplateFolder;
    private String disk;

    public HyperVServerPool(String name, ObjectName objectName, Map<String, String> attributes) throws IllegalArgumentException {
        super(name, objectName, attributes);
        this.hypervUser = attributes.get("user");
        this.hypervPassword = attributes.get("password");
        String vmFolderPath = attributes.get("vmFolderPath");
        if (vmFolderPath == null) {
            throw new IllegalArgumentException("Missing parameter: vmFolderPath");
        }
        this.vmFolder = vmFolderPath.concat("\\").replaceAll("\\\\", "\\\\\\\\");
        String vmTemplateFolderPath = attributes.get("vmTemplateFolderPath");
        if (vmTemplateFolderPath == null) {
            throw new IllegalArgumentException("Missing parameter: vmTemplateFolderPath");
        }
        this.vmTemplateFolder = vmTemplateFolderPath.concat("\\").replaceAll("\\\\", "\\\\\\\\");
        String isLegacyNetAdapter = attributes.get("legacyNetworkAdapter");
        LEGACY_NETWORK_ADAPTER = isLegacyNetAdapter != null ? Boolean.parseBoolean(isLegacyNetAdapter) : true;
        String period = attributes.get("syncPeriodMillis");
        try {
            EVENT_COLLECTOR_PERIOD = period != null ? Integer.parseInt(period) : 10000;
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Wrong value for parameter syncPeriodMillis");
        }
        this.disk = this.vmFolder.substring(0, 2);
        this.eventCollector = new HyperVEventCollector(this);
    }

    @Override
    public String getHypervisor() {
        return "Hyper-V";
    }

    public ExecutorService getExecutorService() {
        return executorService;
    }

    @Override
    public HostMXBean newHost(String hostName, Map<String, String> attributes) throws VMMException {
        try {
            for (HostMXBean host : this.hosts) {
                if (!host.getHostName().equals(hostName)) continue;
                return host;
            }
            String user = attributes.get("user");
            if (user == null) {
                user = this.hypervUser;
                attributes.put("user", user);
            }
            if (user == null) {
                throw new IllegalArgumentException("Host: " + hostName + " Missing parameter: user");
            }
            String password = attributes.get("password");
            if (password == null) {
                password = this.hypervPassword;
                attributes.put("password", password);
            }
            if (password == null) {
                throw new IllegalArgumentException("Host: " + hostName + " Missing parameter: password");
            }
            ObjectName mbeanObjectName = MBeanObjectNamer.makeHostName(this.getPath() + "/" + hostName, hostName);
            HyperVHost host = HyperVHost.newHost(this, mbeanObjectName, hostName, this.vmFolder, this.vmTemplateFolder, new HyperVHost.HypervParams(user, password), this.disk, attributes);
            if (host != null) {
                AgentCommon.getMBeanServer().registerMBean(host, mbeanObjectName);
                this.hosts.add(host);
                ServerPool.logger.info((Object)("In server pool " + this.servername + ": added Host MBean " + mbeanObjectName));
                if (this.imageStore == null) {
                    String vmImageStoreName = hostName + "-VMIStore";
                    this.imageStore = new HyperVVMImageStore(MBeanObjectNamer.makeVMImageStoreName(vmImageStoreName), this.vmTemplateFolder, this.disk, host.getHypervConnection());
                    AgentCommon.getMBeanServer().registerMBean(this.imageStore, this.imageStore.getObjectName());
                }
            }
            this.eventCollector.add(host, new HyperVConnection(hostName, user, password));
            return host;
        }
        catch (Exception ex) {
            ServerPool.logger.error((Object)"Failed to add HyperVHost", (Throwable)ex);
            throw new VMMException(ex);
        }
    }

    @Override
    public VirtualMachineImageStoreMXBean getVMImageStore() {
        return this.imageStore;
    }

    public synchronized void stopEventCollector() {
        this.eventCollector.stop();
    }

    @Override
    public void deleteImageStore() {
        try {
            for (int i = this.imageStore.listVMImageTemplates().size(); i > 0; --i) {
                AgentCommon.getMBeanServer().unregisterMBean(this.imageStore.listVMImageTemplates().get(i - 1).getObjectName());
            }
        }
        catch (Throwable e) {
            ServerPool.logger.error((Object)e);
        }
        try {
            AgentCommon.getMBeanServer().unregisterMBean(this.imageStore.getObjectName());
        }
        catch (Exception e) {
            ServerPool.logger.error((Object)e);
        }
        this.imageStore = null;
    }

    static {
        executorService = Executors.newFixedThreadPool(20);
    }
}

