/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.hyperv;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.domain.ManagedResource;
import org.ow2.jasmine.vmm.agent.driver.hyperv.HyperVConnection;
import org.ow2.jasmine.vmm.agent.driver.hyperv.HyperVHost;
import org.ow2.jasmine.vmm.agent.jmx.MBeanObjectNamer;
import org.ow2.jasmine.vmm.agent.main.AgentCommon;
import org.ow2.jasmine.vmm.api.VMMException;
import org.ow2.jasmine.vmm.api.VirtualMachineImageMXBean;
import org.ow2.jasmine.vmm.api.VirtualMachineImageStoreMXBean;

public class HyperVVMImageStore
extends ManagedResource
implements VirtualMachineImageStoreMXBean {
    static Logger logger = Logger.getLogger(HyperVVMImageStore.class);
    private String imageStorePath;
    private String disk;
    private HyperVConnection connection;
    private ArrayList<HypervVirtualMachineImage> vmList = new ArrayList();

    public HyperVVMImageStore(ObjectName objectName, String imageStorePath, String disk, HyperVConnection connection) throws VMMException {
        super(objectName);
        this.imageStorePath = imageStorePath;
        this.connection = connection;
        this.disk = disk;
        this.sync();
    }

    @Override
    public String getPath() {
        return this.imageStorePath;
    }

    @Override
    public void removeVMImageTemplate(VirtualMachineImageMXBean vmImage) throws VMMException {
        String vmImageID = vmImage.getUUID();
        boolean success = false;
        try {
            logger.debug((Object)("Removing VM image template : " + vmImageID));
            success = this.connection.hostDeleteFile(this.getPath(), vmImageID.concat(".vhd"));
        }
        catch (Exception ex) {
            HyperVHost.logger.error((Object)"Removing VM image template failed: VMI connection failure", (Throwable)ex);
            throw new VMMException("Removing VM image template failed: VMI connection failure", ex);
        }
        if (!success) {
            logger.error((Object)("Failed to removing VM image template : " + vmImageID));
            throw new VMMException("Failed to removing VM image template : " + vmImageID);
        }
        this.sync();
    }

    synchronized void sync() throws VMMException {
        Set<HyperVConnection.Template> tempSet;
        logger.debug((Object)("Syncing VM Image Store " + this.imageStorePath));
        try {
            tempSet = this.connection.getHostVMTemplates(this.imageStorePath.substring(2));
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to get Host VMTemplates", (Throwable)ex);
            throw new VMMException(ex.getMessage());
        }
        for (HyperVConnection.Template temp : tempSet) {
            HypervVirtualMachineImage image;
            String uuid = temp.getName();
            if (this.lookUpByUUID(uuid) != null || (image = this.newVMImage(MBeanObjectNamer.makeVMImageName(uuid), uuid, temp.getName(), temp.getDescription())) == null) continue;
            try {
                AgentCommon.getMBeanServer().registerMBean(image, image.getObjectName());
                logger.info((Object)("Added VMImage name=" + image.name));
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to register VMImage MBean", (Throwable)ex);
                continue;
            }
            this.vmList.add(image);
        }
        ArrayList<HypervVirtualMachineImage> vmListTemp = new ArrayList<HypervVirtualMachineImage>(this.vmList);
        for (HypervVirtualMachineImage image : vmListTemp) {
            boolean match = false;
            for (HyperVConnection.Template temp : tempSet) {
                String uuid = temp.getName();
                if (!image.getUUID().equals(uuid)) continue;
                match = true;
                break;
            }
            if (match) continue;
            try {
                logger.debug((Object)("Removing stale VM image: " + image.getName()));
                AgentCommon.getMBeanServer().unregisterMBean(MBeanObjectNamer.makeVMImageName(image.getName()));
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to unregister VMImage MBean", (Throwable)ex);
            }
            this.vmList.remove(image);
        }
    }

    @Override
    public VirtualMachineImageMXBean lookUpByUUID(String uuid) {
        for (HypervVirtualMachineImage image : this.vmList) {
            if (!image.getUUID().equals(uuid)) continue;
            return image;
        }
        return null;
    }

    @Override
    public List<VirtualMachineImageMXBean> listVMImageTemplates() {
        logger.debug((Object)"Listing VM images...");
        ArrayList<VirtualMachineImageMXBean> result = new ArrayList<VirtualMachineImageMXBean>(this.vmList);
        return result;
    }

    @Override
    public long getCapacityMB() {
        long size = 0L;
        try {
            size = this.connection.getHostSizeMB(this.disk);
            logger.debug((Object)("GetCapacityMB of imageStore : " + size));
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to get CapacityMB of imageStore", (Throwable)ex);
        }
        return size;
    }

    @Override
    public long getFreeSpaceMB() {
        long freeSpace = 0L;
        try {
            freeSpace = this.connection.getHostFreeSpaceMB(this.disk);
            logger.debug((Object)("GetFreeSpaceMB of imageStore : " + freeSpace));
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to get FreeSpaceMB of imageStore", (Throwable)ex);
        }
        return freeSpace;
    }

    @Override
    public String getName() {
        return "ImageStore(" + this.imageStorePath.substring(2) + ")";
    }

    public HypervVirtualMachineImage newVMImage(ObjectName objectName, String uuid, String name, String description) {
        HypervVirtualMachineImage vmi = new HypervVirtualMachineImage(objectName);
        vmi.uuid = uuid;
        vmi.name = name;
        vmi.description = description;
        return vmi;
    }

    class HypervVirtualMachineImage
    extends ManagedResource
    implements VirtualMachineImageMXBean {
        private String name;
        private String uuid;
        private String description;

        private HypervVirtualMachineImage(ObjectName objectName) {
            super(objectName);
        }

        @Override
        public Map<String, String> getMetaData() {
            return null;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getUUID() {
            return this.uuid;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public String getFileName() {
            return HyperVVMImageStore.this.imageStorePath + this.name;
        }
    }
}

