/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.libvirt;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.libvirt.Connect;
import org.libvirt.Domain;
import org.libvirt.DomainBlockStats;
import org.libvirt.DomainInterfaceStats;
import org.libvirt.LibvirtException;
import org.ow2.jasmine.vmm.agent.driver.libvirt.LibvirtConfigFileUtils;
import org.ow2.jasmine.vmm.agent.driver.libvirt.LibvirtHost;
import org.ow2.jasmine.vmm.agent.driver.libvirt.LibvirtVirtualMachine;
import org.ow2.jasmine.vmm.agent.driver.util.ResourceUsageHelper;
import org.ow2.jasmine.vmm.api.ResourceUsage;
import org.ow2.jasmine.vmm.api.VMMException;
import org.ow2.jasmine.vmm.api.VirtualMachineMXBean;

public class LibvirtPerfCollector
implements Runnable {
    static Logger logger = Logger.getLogger(LibvirtPerfCollector.class);
    static int interval = 3;
    private boolean isRunning;
    private Thread thread;
    LibvirtHost host;
    Connect conn;
    LibvirtDomainMetrics[] libvirtDomainMetricsTab;
    int[] listIdVM = null;
    String VmName;

    public LibvirtPerfCollector(LibvirtHost host) {
        this.host = host;
        this.thread = new Thread(this);
        logger.info((Object)("Libvirt PerfCollector launch on host : " + host.getHostName()));
    }

    public void start() {
        this.isRunning = true;
        this.thread.start();
    }

    public void stop() {
        this.isRunning = false;
    }

    private void init() {
        try {
            this.listIdVM = this.conn.listDomains();
            this.libvirtDomainMetricsTab = new LibvirtDomainMetrics[this.listIdVM.length];
            for (int i = 0; i < this.libvirtDomainMetricsTab.length; ++i) {
                LibvirtDomainMetrics temp;
                Domain d = this.conn.domainLookupByID(this.listIdVM[i]);
                this.VmName = d.getName();
                this.libvirtDomainMetricsTab[i] = temp = new LibvirtDomainMetrics(i, d.getName());
            }
        }
        catch (LibvirtException e) {
            logger.error((Object)("Error during listing of the available VM on host : " + this.host.getHostName()), (Throwable)e);
        }
    }

    @Override
    public void run() {
        try {
            this.conn = this.host.getLibvirtAPIConnection();
        }
        catch (LibvirtException ex) {
            LibvirtHost.logger.error((Object)"Failed to create Libvirt connection", (Throwable)ex);
            return;
        }
        this.init();
        while (this.isRunning) {
            this.readAllVMCPUload(1);
            this.readAllVMDiskIO(1);
            this.readAllVMNetIO(1);
            try {
                Thread.sleep(interval * 1000);
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
            this.readAllVMCPUload(2);
            this.readAllVMMemoryUsage();
            this.readAllVMDiskIO(2);
            this.readAllVMNetIO(2);
            Date samplingTime = new Date(System.currentTimeMillis());
            this.updateAllVM(samplingTime);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                if (!this.listIdVM.equals(this.conn.listDomains())) {
                    this.init();
                }
            }
            catch (LibvirtException e) {
                e.printStackTrace();
            }
            HashMap<String, Object> notifUserData = new HashMap<String, Object>();
            for (LibvirtVirtualMachine vm : this.host.getVMs()) {
                try {
                    if (vm.getState() != VirtualMachineMXBean.PowerState.RUNNING || vm.getResourceUsage() == null || vm.getResourceUsage().getSamplingTime() != samplingTime) continue;
                    notifUserData.put(vm.getNameLabel(), ResourceUsageHelper.serialize(vm.getResourceUsage()));
                }
                catch (VMMException e) {}
            }
            this.host.emitNotification("host.perfreport", "Resource Usage", notifUserData);
        }
    }

    private void readAllVMCPUload(int passNumber) {
        if (passNumber == 1) {
            for (LibvirtDomainMetrics element : this.libvirtDomainMetricsTab) {
                try {
                    Domain d = this.conn.domainLookupByName(element.getName());
                    this.VmName = d.getName();
                    element.setCpuTime(d.getInfo().cpuTime);
                    element.cpuSamplingTimeMillis = System.currentTimeMillis();
                }
                catch (LibvirtException ex) {
                    // empty catch block
                }
            }
        } else {
            for (LibvirtDomainMetrics element : this.libvirtDomainMetricsTab) {
                try {
                    Domain d = this.conn.domainLookupByName(element.getName());
                    this.VmName = d.getName();
                    long diffEchantCPU = element.getCpuTime() - d.getInfo().cpuTime;
                    double deltaTime = (System.currentTimeMillis() - element.cpuSamplingTimeMillis) * 1000000L;
                    double denom = (double)this.host.getNumCPU() * deltaTime;
                    double result1 = -((double)diffEchantCPU / denom);
                    if (result1 <= 0.0) {
                        result1 = 0.0;
                    }
                    element.setCpuLoad((float)result1);
                }
                catch (LibvirtException ex) {
                    // empty catch block
                }
            }
        }
    }

    private void readAllVMMemoryUsage() {
        try {
            for (LibvirtDomainMetrics element : this.libvirtDomainMetricsTab) {
                Domain d;
                try {
                    d = this.conn.domainLookupByName(element.getName());
                }
                catch (LibvirtException ex) {
                    continue;
                }
                this.VmName = d.getName();
                element.setMemUsed(d.getInfo().memory);
            }
        }
        catch (LibvirtException ex) {
            logger.error((Object)("LibvirtException during Memory Usage collect on VM : " + this.VmName), (Throwable)ex);
        }
    }

    private void readAllVMDiskIO(int passNumber) {
        try {
            for (LibvirtDomainMetrics element : this.libvirtDomainMetricsTab) {
                Domain d;
                try {
                    d = this.conn.domainLookupByName(element.getName());
                }
                catch (LibvirtException ex) {
                    continue;
                }
                this.VmName = d.getName();
                String xmlDesc = d.getXMLDesc(0);
                if (xmlDesc.indexOf("hvm") != -1) continue;
                List<ResourceUsage.DiskStats> list = element.getDiskStatsList();
                if (list == null) {
                    list = new LinkedList<ResourceUsage.DiskStats>();
                    element.setDiskStatsList(list);
                }
                List<String> disks = LibvirtConfigFileUtils.getDiskDevices(xmlDesc);
                if (passNumber == 1) {
                    element.diskStatsSamplingTimeMillis = System.currentTimeMillis();
                }
                for (String disk : disks) {
                    ResourceUsage.DiskStats diskStats = null;
                    for (ResourceUsage.DiskStats ds : list) {
                        if (!ds.getDeviceName().equals(disk)) continue;
                        diskStats = ds;
                        break;
                    }
                    if (diskStats == null) {
                        diskStats = new ResourceUsage.DiskStats();
                        list.add(diskStats);
                    }
                    diskStats.setDeviceName(disk);
                    DomainBlockStats stats = d.blockStats(disk);
                    if (passNumber == 1) {
                        diskStats.setDiskReadKBytePerSec(stats.rd_bytes);
                        diskStats.setDiskWrittenKBytesPerSec(stats.wr_bytes);
                        continue;
                    }
                    long deltaTimeMillis = System.currentTimeMillis() - element.diskStatsSamplingTimeMillis;
                    diskStats.setDiskReadKBytePerSec(1000L * (stats.rd_bytes - diskStats.getDiskReadKBytePerSec()) / (1024L * deltaTimeMillis));
                    diskStats.setDiskWrittenKBytesPerSec(1000L * (stats.wr_bytes - diskStats.getDiskWrittenKBytesPerSec()) / (1024L * deltaTimeMillis));
                }
            }
        }
        catch (LibvirtException e) {
            logger.debug((Object)("LibvirtException during Disk I/O collect on VM : " + this.VmName));
        }
    }

    private void readAllVMNetIO(int passNumber) {
        try {
            for (LibvirtDomainMetrics element : this.libvirtDomainMetricsTab) {
                Domain d;
                try {
                    d = this.conn.domainLookupByName(element.getName());
                }
                catch (LibvirtException ex) {
                    continue;
                }
                this.VmName = d.getName();
                String xmlDesc = d.getXMLDesc(0);
                List<ResourceUsage.NetworkStats> list = element.getNetworksStatsList();
                if (list == null) {
                    list = new LinkedList<ResourceUsage.NetworkStats>();
                    element.setNetworksStatsList(list);
                }
                List<String> ethList = LibvirtConfigFileUtils.getNetDevices(xmlDesc);
                if (passNumber == 1) {
                    element.netStatsSamplingTimeMillis = System.currentTimeMillis();
                }
                for (String eth : ethList) {
                    ResourceUsage.NetworkStats netStats = null;
                    for (ResourceUsage.NetworkStats ns : list) {
                        if (!ns.getDeviceName().equals(eth)) continue;
                        netStats = ns;
                        break;
                    }
                    if (netStats == null) {
                        netStats = new ResourceUsage.NetworkStats();
                        list.add(netStats);
                    }
                    netStats.setDeviceName(eth);
                    DomainInterfaceStats stats = d.interfaceStats(eth);
                    if (passNumber == 1) {
                        netStats.setNetReceivedKbitPerSec(stats.rx_bytes);
                        netStats.setNetTransmittedKbitPerSec(stats.tx_bytes);
                        continue;
                    }
                    long deltaTimeMillis = System.currentTimeMillis() - element.netStatsSamplingTimeMillis;
                    netStats.setNetReceivedKbitPerSec(1000L * (stats.rx_bytes - netStats.getNetReceivedKbitPerSec()) / (128L * deltaTimeMillis));
                    netStats.setNetTransmittedKbitPerSec(1000L * (stats.tx_bytes - netStats.getNetTransmittedKbitPerSec()) / (128L * deltaTimeMillis));
                }
            }
        }
        catch (LibvirtException ex) {
            logger.debug((Object)("LibvirtException during Network I/O collect on VM : " + this.VmName), (Throwable)ex);
        }
    }

    private void updateAllVM(Date samplingTime) {
        for (LibvirtVirtualMachine vm : this.host.getVMs()) {
            for (LibvirtDomainMetrics element : this.libvirtDomainMetricsTab) {
                if (!element.getName().equals(vm.getNameLabel())) continue;
                ResourceUsage vmUsage = new ResourceUsage();
                vmUsage.setSamplingTime(samplingTime);
                vmUsage.setCpuLoad(element.getCpuLoad());
                vmUsage.setMemoryUsedKBytes(element.getMemUsed());
                vmUsage.setDiskStats(element.getDiskStatsList());
                vmUsage.setNetworkStats(element.getNetworksStatsList());
                vm.updateCurrentResourceUsage(vmUsage);
            }
        }
    }

    private static class LibvirtDomainMetrics {
        private int id;
        private String name;
        private float cpuLoad = -1.0f;
        private long cpuTime;
        long cpuSamplingTimeMillis;
        private long memUsed = -1L;
        long diskStatsSamplingTimeMillis;
        private List<ResourceUsage.DiskStats> DiskStatsList = null;
        long netStatsSamplingTimeMillis;
        private List<ResourceUsage.NetworkStats> NetworksStatsList = null;

        public LibvirtDomainMetrics(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public float getCpuLoad() {
            return this.cpuLoad;
        }

        public long getMemUsed() {
            return this.memUsed;
        }

        public List<ResourceUsage.DiskStats> getDiskStatsList() {
            return this.DiskStatsList;
        }

        public List<ResourceUsage.NetworkStats> getNetworksStatsList() {
            return this.NetworksStatsList;
        }

        public synchronized long getCpuTime() {
            return this.cpuTime;
        }

        public synchronized void setCpuTime(long cpuTime) {
            this.cpuTime = cpuTime;
        }

        public void setCpuLoad(float cpuLoad) {
            this.cpuLoad = cpuLoad;
        }

        public void setMemUsed(long memUsed) {
            this.memUsed = memUsed;
        }

        public void setDiskStatsList(List<ResourceUsage.DiskStats> diskStats) {
            this.DiskStatsList = diskStats;
        }

        public void setNetworksStatsList(List<ResourceUsage.NetworkStats> networkStats) {
            this.NetworksStatsList = networkStats;
        }
    }
}

