/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.libvirt;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.xml.xpath.XPathConstants;
import org.apache.log4j.Logger;
import org.libvirt.Domain;
import org.libvirt.DomainInfo;
import org.libvirt.LibvirtException;
import org.libvirt.SchedParameter;
import org.libvirt.SchedUintParameter;
import org.libvirt.VcpuInfo;
import org.ow2.jasmine.vmm.agent.domain.ManagedResource;
import org.ow2.jasmine.vmm.agent.driver.libvirt.ImageCatalog;
import org.ow2.jasmine.vmm.agent.driver.libvirt.LibvirtConfigFileUtils;
import org.ow2.jasmine.vmm.agent.driver.libvirt.LibvirtHost;
import org.ow2.jasmine.vmm.agent.driver.util.RemoteExec;
import org.ow2.jasmine.vmm.api.BadVMPowerStateException;
import org.ow2.jasmine.vmm.api.HostMXBean;
import org.ow2.jasmine.vmm.api.IllegalOperationException;
import org.ow2.jasmine.vmm.api.InsufficientResourcesException;
import org.ow2.jasmine.vmm.api.ResourceUsage;
import org.ow2.jasmine.vmm.api.VMCustomizationSpec;
import org.ow2.jasmine.vmm.api.VMMException;
import org.ow2.jasmine.vmm.api.VirtualMachineImageMXBean;
import org.ow2.jasmine.vmm.api.VirtualMachineMXBean;

public class LibvirtVirtualMachine
extends ManagedResource
implements VirtualMachineMXBean {
    static Logger logger = Logger.getLogger(LibvirtVirtualMachine.class);
    private LibvirtHost host;
    private Domain domain;
    private String uuid;
    private String name;
    private String ipAddress;
    private String macAddress;
    private VirtualMachineMXBean.PowerState cachedPowerState = VirtualMachineMXBean.PowerState.UNKNOWN;
    boolean isSynchronized = true;
    private boolean isMigrating;
    private ResourceUsage currentResourceUsage = new ResourceUsage();

    public LibvirtVirtualMachine(ObjectName objectName, LibvirtHost host, Domain domain, Map<String, String> userData) throws VMMException {
        super(objectName);
        try {
            this.host = host;
            this.domain = domain;
            this.uuid = domain.getUUIDString();
            this.name = domain.getName();
        }
        catch (LibvirtException ex) {
            throw LibvirtVirtualMachine.translateLibvirtException(ex);
        }
    }

    @Override
    public boolean canLiveMigrateToHost(HostMXBean targetHost) throws VMMException {
        LibvirtHost host = null;
        for (HostMXBean h : this.host.getServerPool().getManagedHosts()) {
            if (!h.getObjectName().equals(targetHost.getObjectName())) continue;
            host = (LibvirtHost)h;
            break;
        }
        return host != null && host != this.host && this.getMemorySizeMB() < host.getFreeMemoryMB();
    }

    public synchronized boolean isSynchronized() {
        return this.isSynchronized;
    }

    public synchronized void setSynchronized(boolean isSynchronized) {
        this.isSynchronized = isSynchronized;
    }

    public synchronized boolean isMigrating() {
        return this.isMigrating;
    }

    public synchronized void setMigrating(boolean isMigrating) {
        this.isMigrating = isMigrating;
    }

    @Override
    public VirtualMachineMXBean cloneVM(String clonedVmName, VMCustomizationSpec custSpec, boolean sync) throws InsufficientResourcesException, VMMException {
        return this.host.cloneVM(this.getNameLabel(), clonedVmName, custSpec, sync);
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public HostMXBean getHostMBean() {
        return this.host;
    }

    public long getDomID() {
        try {
            return this.domain.getID();
        }
        catch (LibvirtException ex) {
            logger.error((Object)ex);
            return -1L;
        }
    }

    public List<String> getDiskFiles() throws VMMException {
        try {
            String xmlDesc = this.domain.getXMLDesc(0);
            return LibvirtConfigFileUtils.getDiskFiles(xmlDesc);
        }
        catch (LibvirtException ex) {
            throw LibvirtVirtualMachine.translateLibvirtException(ex);
        }
    }

    @Override
    public Date getStartTime() {
        return null;
    }

    public long getUpTimeSeconds() {
        return -1L;
    }

    void updateCurrentResourceUsage(ResourceUsage usage) {
        this.currentResourceUsage = usage;
    }

    @Override
    public ResourceUsage getResourceUsage() {
        return this.currentResourceUsage;
    }

    @Override
    public float getCPULoad() {
        return this.currentResourceUsage.getCpuLoad();
    }

    @Override
    public float[] getLoadPerVCPU() throws VMMException {
        try {
            VcpuInfo[] vcpuInfos1 = this.domain.getVcpusInfo();
            try {
                Thread.sleep(500L);
            }
            catch (Exception ex) {
                // empty catch block
            }
            VcpuInfo[] vcpuInfos2 = this.domain.getVcpusInfo();
            float[] vcpuLoad = new float[vcpuInfos1.length];
            for (int i = 0; i < vcpuInfos1.length; ++i) {
                vcpuLoad[i] = (float)((double)(vcpuInfos2[i].cpuTime - vcpuInfos1[i].cpuTime) / Math.pow(10.0, 9.0));
            }
            return vcpuLoad;
        }
        catch (LibvirtException ex) {
            throw LibvirtVirtualMachine.translateLibvirtException(ex);
        }
    }

    @Override
    public long getMemorySizeMB() throws VMMException {
        try {
            return this.domain.getInfo().maxMem / 1024L;
        }
        catch (LibvirtException ex) {
            throw new VMMException(ex);
        }
    }

    @Override
    public void setMemorySizeMB(long size) throws VMMException {
        try {
            this.domain.setMaxMemory(size * 1024L);
            this.domain.setMemory(size * 1024L);
        }
        catch (LibvirtException ex) {
            throw LibvirtVirtualMachine.translateLibvirtException(ex);
        }
    }

    @Override
    public long getMemoryUsedMB() throws VMMException {
        try {
            return this.domain.getInfo().memory / 1024L;
        }
        catch (LibvirtException ex) {
            throw LibvirtVirtualMachine.translateLibvirtException(ex);
        }
    }

    @Override
    public String getNameLabel() {
        return this.name;
    }

    public void addUserData(String key, String value) throws VMMException {
        try {
            RemoteExec.Result result = null;
            String command = "xenstore-write /domain/" + this.uuid + "/" + key + " " + value + " 2>&1";
            logger.debug((Object)("VM " + this.name + " addUserData: " + command));
            result = RemoteExec.commandAsRoot(this.host.getHostName(), this.host.getSshAuthInfo(), command);
            if (result.exitCode != 0) {
                logger.debug((Object)("VM " + this.name + " addUserData failed: " + result.output));
                logger.error((Object)(command + " returns " + result.exitCode));
            }
        }
        catch (Exception ex) {
            throw new VMMException(ex.getMessage());
        }
    }

    @Override
    public String getUserData(String key) throws VMMException {
        try {
            RemoteExec.Result result = null;
            String command = "xenstore-read /domain/" + this.uuid + "/" + key;
            result = RemoteExec.commandAsRoot(this.host.getHostName(), this.host.getSshAuthInfo(), command);
            if (result.exitCode != 0) {
                throw new VMMException("Cannot get user data :" + result.error);
            }
            return result.output;
        }
        catch (Exception ex) {
            throw new VMMException(ex.getMessage());
        }
    }

    @Override
    public String getConsole() throws VMMException {
        try {
            String xmlDesc = this.domain.getXMLDesc(0);
            String vncPortString = (String)LibvirtConfigFileUtils.getConfigItem(xmlDesc, "/domain/devices/graphics[@type='vnc']/@port", XPathConstants.STRING);
            if (vncPortString == null || vncPortString.equals("")) {
                return null;
            }
            String console = "vnc://" + this.host.getHostName() + ":" + Integer.parseInt(vncPortString);
            logger.debug((Object)("VM " + this.name + " console=" + console));
            return console;
        }
        catch (LibvirtException ex) {
            throw LibvirtVirtualMachine.translateLibvirtException(ex);
        }
    }

    @Override
    public int getNumVCPUs() throws VMMException {
        DomainInfo info;
        try {
            info = this.domain.getInfo();
        }
        catch (LibvirtException ex) {
            throw LibvirtVirtualMachine.translateLibvirtException(ex);
        }
        return info.nrVirtCpu;
    }

    @Override
    public boolean[][] getCPUAffinity() throws VMMException {
        try {
            int numVCPUs = this.domain.getInfo().nrVirtCpu;
            int numPCPUs = this.domain.getConnect().nodeInfo().cpus;
            int numMaxPCPUs = this.domain.getConnect().nodeInfo().maxCpus();
            int[] cpuMap = this.domain.getVcpusCpuMaps();
            boolean[][] result = new boolean[numVCPUs][];
            for (int i = 0; i < numVCPUs; ++i) {
                result[i] = new boolean[numPCPUs];
            }
            int maxVCPUS = this.domain.getMaxVcpus();
            int cpuMapLength = this.domain.cpuMapLength(numMaxPCPUs);
            for (int i = 0; i < numVCPUs; ++i) {
                for (int j = 0; j < numPCPUs; ++j) {
                    result[i][j] = (cpuMap[i * cpuMapLength + j / 8] & 1 << j % 8) != 0;
                }
            }
            return result;
        }
        catch (LibvirtException ex) {
            throw LibvirtVirtualMachine.translateLibvirtException(ex);
        }
    }

    @Override
    public void setCPUAffinity(boolean[][] affinity) throws VMMException {
        try {
            if (affinity == null) {
                throw new IllegalArgumentException();
            }
            int mapLength = (this.domain.getConnect().nodeInfo().cpus + 7) / 8;
            for (int vcpuIndex = 0; vcpuIndex < affinity.length; ++vcpuIndex) {
                int[] cpuMap = new int[mapLength];
                if (affinity[vcpuIndex] == null) {
                    throw new IllegalArgumentException();
                }
                for (int pcpuIndex = 0; pcpuIndex < affinity[vcpuIndex].length; ++pcpuIndex) {
                    if (!affinity[vcpuIndex][pcpuIndex]) continue;
                    int n = pcpuIndex / 8;
                    cpuMap[n] = cpuMap[n] | 1 << pcpuIndex % 8;
                }
                this.domain.pinVcpu(vcpuIndex, cpuMap);
            }
        }
        catch (LibvirtException ex) {
            throw LibvirtVirtualMachine.translateLibvirtException(ex);
        }
    }

    @Override
    public int getSchedulingCap() throws VMMException {
        try {
            SchedParameter[] schedParams;
            for (SchedParameter param : schedParams = this.domain.getSchedulerParameters()) {
                if (!param.field.equals("cap")) continue;
                return ((SchedUintParameter)param).value;
            }
            return -1;
        }
        catch (LibvirtException ex) {
            throw LibvirtVirtualMachine.translateLibvirtException(ex);
        }
    }

    @Override
    public int getSchedulingWeight() throws VMMException {
        try {
            SchedParameter[] schedParams;
            for (SchedParameter param : schedParams = this.domain.getSchedulerParameters()) {
                if (!param.field.equals("weight")) continue;
                return ((SchedUintParameter)param).value;
            }
            return -1;
        }
        catch (LibvirtException ex) {
            throw LibvirtVirtualMachine.translateLibvirtException(ex);
        }
    }

    @Override
    public VirtualMachineMXBean.PowerState getState() throws VMMException {
        DomainInfo.DomainState state;
        try {
            state = this.domain.getInfo().state;
        }
        catch (LibvirtException ex) {
            throw LibvirtVirtualMachine.translateLibvirtException(ex);
        }
        VirtualMachineMXBean.PowerState newState = VirtualMachineMXBean.PowerState.UNKNOWN;
        switch (state) {
            case VIR_DOMAIN_BLOCKED: 
            case VIR_DOMAIN_RUNNING: 
            case VIR_DOMAIN_SHUTDOWN: {
                newState = VirtualMachineMXBean.PowerState.RUNNING;
                break;
            }
            case VIR_DOMAIN_SHUTOFF: {
                newState = VirtualMachineMXBean.PowerState.HALTED;
                break;
            }
            case VIR_DOMAIN_PAUSED: {
                newState = VirtualMachineMXBean.PowerState.PAUSED;
                break;
            }
            case VIR_DOMAIN_CRASHED: {
                newState = VirtualMachineMXBean.PowerState.UNKNOWN;
                break;
            }
            case VIR_DOMAIN_NOSTATE: {
                newState = this.cachedPowerState;
            }
        }
        if (newState == VirtualMachineMXBean.PowerState.UNKNOWN) {
            logger.debug((Object)("VM " + this.getNameLabel() + " state=" + state));
        }
        if (newState != this.cachedPowerState) {
            this.emitNotification("vm.state", newState.toString(), null);
            logger.debug((Object)("VM " + this.getNameLabel() + " new power state: " + newState.toString()));
            this.cachedPowerState = newState;
        }
        return this.cachedPowerState;
    }

    @Override
    public String getGuestIpAddress() throws VMMException {
        try {
            if (this.getState() != VirtualMachineMXBean.PowerState.RUNNING) {
                return "unknown";
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (this.ipAddress == null) {
            int nbAttempts = 10;
            while (nbAttempts-- > 0) {
                try {
                    this.ipAddress = this.host.getIPAddress(this.getMacAddress());
                }
                catch (Exception ex) {
                    throw new VMMException(ex.getMessage());
                }
                if (this.ipAddress != null && !this.ipAddress.equals("")) break;
                try {
                    TimeUnit.SECONDS.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return this.ipAddress == null ? "unknown" : this.ipAddress;
    }

    @Override
    public String getMacAddress() throws VMMException {
        if (this.macAddress == null) {
            String xmlDesc;
            try {
                xmlDesc = this.domain.getXMLDesc(0);
            }
            catch (LibvirtException ex) {
                throw LibvirtVirtualMachine.translateLibvirtException(ex);
            }
            int i = xmlDesc.indexOf("mac address");
            if (i == -1) {
                return null;
            }
            int startIndex = i + "mac address".length() + 2;
            this.macAddress = xmlDesc.substring(startIndex, startIndex + 17);
        }
        return this.macAddress;
    }

    @Override
    public void setNumVCPUs(int numVCPUs) throws VMMException {
        try {
            this.domain.setVcpus(numVCPUs);
        }
        catch (LibvirtException ex) {
            throw LibvirtVirtualMachine.translateLibvirtException(ex);
        }
    }

    @Override
    public void setSchedulingCap(int schedulingCap) throws VMMException {
        SchedUintParameter cap = new SchedUintParameter(schedulingCap);
        cap.field = "cap";
        try {
            this.domain.setSchedulerParameters(new SchedParameter[]{cap});
        }
        catch (LibvirtException ex) {
            throw LibvirtVirtualMachine.translateLibvirtException(ex);
        }
    }

    @Override
    public void setSchedulingWeight(int schedulingWeight) throws VMMException {
        SchedUintParameter cap = new SchedUintParameter(schedulingWeight);
        cap.field = "weight";
        try {
            this.domain.setSchedulerParameters(new SchedParameter[]{cap});
        }
        catch (LibvirtException ex) {
            throw LibvirtVirtualMachine.translateLibvirtException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void migrate(HostMXBean targetHost, boolean live) throws IllegalOperationException, VMMException {
        this.setMigrating(true);
        try {
            String targetHostName = targetHost.getHostName();
            logger.info((Object)("Attempting live migration of VM " + this.name + " to host " + targetHostName));
            boolean foundHostInServerPool = false;
            for (HostMXBean h : this.host.getServerPool().getManagedHosts()) {
                if (!h.getHostName().equals(targetHost.getHostName())) continue;
                foundHostInServerPool = true;
                targetHost = h;
                break;
            }
            if (!foundHostInServerPool) {
                throw new IllegalOperationException("Source and target hosts belong to different server pools");
            }
            LibvirtHost targetLibvirtHost = (LibvirtHost)targetHost;
            logger.info((Object)("VM " + this.name + " live migration to host " + targetHostName + "..."));
            this.emitNotification("vm.migration.start", targetHostName, null);
            Domain newDomain = null;
            try {
                newDomain = this.domain.migrate(targetLibvirtHost.getLibvirtAPIConnection(), live ? 1L : 0L, null, null, 0L);
            }
            catch (LibvirtException ex) {
                logger.error((Object)"Migration failure", (Throwable)ex);
                throw new VMMException("Migration failure: " + ex.getMessage());
            }
            try {
                String xmlDesc = this.domain.getXMLDesc(0);
                this.domain.undefine();
                newDomain.getConnect().domainDefineXML(xmlDesc);
            }
            catch (LibvirtException ex) {
                logger.error((Object)ex);
            }
            logger.info((Object)("VM " + this.name + " live migration done"));
            LibvirtHost oldHost = this.host;
            this.host.postMigrateVM(this, targetLibvirtHost);
            this.host = targetLibvirtHost;
            this.domain = newDomain;
            this.emitNotification("vm.migration", targetHostName, new String[]{oldHost.getObjectName().toString(), targetLibvirtHost.getObjectName().toString()});
        }
        finally {
            this.setMigrating(false);
        }
    }

    @Override
    public void shutdown() throws VMMException {
        try {
            this.domain.shutdown();
        }
        catch (LibvirtException ex) {
            throw LibvirtVirtualMachine.translateLibvirtException(ex);
        }
    }

    @Override
    public void start() throws VMMException {
        try {
            logger.debug((Object)("START VM: uuid=" + this.domain.getUUIDString()));
            this.domain.create();
            this.host.sync();
        }
        catch (LibvirtException ex) {
            logger.error((Object)("Libvirt exception while starting VM " + this.name), (Throwable)ex);
        }
    }

    @Override
    public void reboot() throws VMMException {
        try {
            this.domain.reboot(0);
        }
        catch (LibvirtException ex) {
            throw LibvirtVirtualMachine.translateLibvirtException(ex);
        }
    }

    @Override
    public void suspend() throws VMMException {
        try {
            this.domain.save(" /tmp/" + this.getNameLabel() + ".save");
            this.host.sync();
        }
        catch (LibvirtException ex) {
            throw LibvirtVirtualMachine.translateLibvirtException(ex);
        }
    }

    @Override
    public void resume() throws VMMException {
        try {
            this.domain.getConnect().restore("/tmp/" + this.getNameLabel() + ".save");
            this.host.sync();
        }
        catch (LibvirtException ex) {
            throw LibvirtVirtualMachine.translateLibvirtException(ex);
        }
    }

    @Override
    public void pause() throws VMMException {
        try {
            this.domain.suspend();
            this.host.sync();
        }
        catch (LibvirtException ex) {
            throw LibvirtVirtualMachine.translateLibvirtException(ex);
        }
    }

    @Override
    public void unpause() throws VMMException {
        try {
            this.domain.resume();
            this.host.sync();
        }
        catch (LibvirtException ex) {
            throw LibvirtVirtualMachine.translateLibvirtException(ex);
        }
    }

    @Override
    public void destroy() throws VMMException {
        List<String> diskFiles;
        try {
            String xmlDesc = this.domain.getXMLDesc(0);
            diskFiles = LibvirtConfigFileUtils.getDiskFiles(xmlDesc);
            try {
                if (this.getState() == VirtualMachineMXBean.PowerState.RUNNING) {
                    this.domain.destroy();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.domain.undefine();
        }
        catch (LibvirtException ex) {
            throw LibvirtVirtualMachine.translateLibvirtException(ex);
        }
        for (String file : diskFiles) {
            RemoteExec.Result result;
            String command = "rm -f " + file;
            try {
                logger.debug((Object)("Detroying disk: " + command));
                result = RemoteExec.commandAsRoot(this.host.getHostName(), this.host.getSshAuthInfo(), command);
            }
            catch (RemoteExec.SshException ex) {
                throw new VMMException("VM cloning failed: SSH connection failure", ex);
            }
            if (result.exitCode == 0) continue;
            throw new VMMException("VM cloning failed: " + result.error);
        }
        this.host.sync();
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"vm.state", "vm.migration.abort", "vm.migration.start", "vm.migration", "log", "vm.error"}, Notification.class.getName(), "VM event")};
    }

    @Override
    public VirtualMachineImageMXBean makeTemplate(String name, String description, Map<String, String> metadata) throws InsufficientResourcesException, IllegalOperationException, BadVMPowerStateException, VMMException {
        return ((ImageCatalog)this.host.getVMImageStore()).newVMImageTemplate(this, name, description, metadata);
    }

    static VMMException translateLibvirtException(LibvirtException ex) {
        return new VMMException(ex.toString());
    }
}

