/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.util;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class RemoteExec {
    static Logger logger = Logger.getLogger(RemoteExec.class);
    private static ExecutorService executorService = Executors.newFixedThreadPool(10);

    public static Result commandAsRoot(String host, SshAuthInfo authInfo, String command) throws SshException {
        return RemoteExec.command(host, "root", authInfo, command);
    }

    public static Result command(String host, String user, final SshAuthInfo authInfo, String command) throws SshException {
        try {
            String s;
            int i;
            JSch jsch = new JSch();
            if (authInfo.keyFile != null) {
                jsch.addIdentity(authInfo.keyFile, "passphrase");
            }
            Session session = jsch.getSession(user, host, 22);
            session.setUserInfo(new UserInfo(){

                public String getPassphrase() {
                    return null;
                }

                public String getPassword() {
                    return authInfo.password;
                }

                public boolean promptPassphrase(String arg0) {
                    return true;
                }

                public boolean promptPassword(String arg0) {
                    return true;
                }

                public boolean promptYesNo(String arg0) {
                    return true;
                }

                public void showMessage(String arg0) {
                }
            });
            session.connect();
            ChannelExec channel = (ChannelExec)session.openChannel("exec");
            channel.setCommand(command);
            InputStream in = channel.getInputStream();
            InputStream err = channel.getErrStream();
            channel.connect();
            Result result = new Result();
            StringBuffer output = new StringBuffer();
            StringBuffer error = new StringBuffer();
            byte[] tmp = new byte[1024];
            while (true) {
                if (in.available() > 0 && (i = in.read(tmp, 0, 1024)) >= 0) {
                    s = new String(tmp, 0, i);
                    output.append(s);
                    continue;
                }
                if (channel.isClosed()) break;
                try {
                    Thread.sleep(100L);
                }
                catch (Exception ee) {}
            }
            result.exitCode = channel.getExitStatus();
            while (true) {
                if (err.available() > 0 && (i = err.read(tmp, 0, 1024)) >= 0) {
                    s = new String(tmp, 0, i);
                    error.append(s);
                    continue;
                }
                if (channel.isClosed()) break;
                try {
                    Thread.sleep(100L);
                }
                catch (Exception ee) {}
            }
            result.exitCode = channel.getExitStatus();
            channel.disconnect();
            session.disconnect();
            result.output = new String(output);
            result.error = new String(error);
            return result;
        }
        catch (Exception ex) {
            logger.error((Object)("SSH failure: user=[" + user + "] auth=[" + authInfo + "]"), (Throwable)ex);
            SshException e = new SshException();
            e.initCause(ex);
            throw e;
        }
    }

    public static class SSHExec {
        private String host;
        private String user;
        private SshAuthInfo authInfo;
        private String command;
        private int exitCode;
        private ChannelExec channel;
        private Session session;
        private ReaderTask outReader;
        private ReaderTask errReader;

        public SSHExec(String host, String user, SshAuthInfo authInfo, String command) {
            this.host = host;
            this.user = user;
            this.authInfo = authInfo;
            this.command = command;
        }

        public void connect(SSHExecCallback outCallback, SSHExecCallback errCallback) throws SshException {
            try {
                JSch jsch = new JSch();
                if (this.authInfo.keyFile != null) {
                    jsch.addIdentity(this.authInfo.keyFile, "passphrase");
                }
                Session session = jsch.getSession(this.user, this.host, 22);
                session.setUserInfo((UserInfo)new MyUserInfo(this.authInfo.password));
                session.connect();
                this.channel = (ChannelExec)session.openChannel("exec");
                this.channel.setCommand(this.command);
                InputStream in = this.channel.getInputStream();
                InputStream err = this.channel.getErrStream();
                this.channel.connect();
                this.outReader = new ReaderTask(this.channel, in, outCallback);
                this.errReader = new ReaderTask(this.channel, err, errCallback);
                executorService.execute(this.outReader);
                executorService.execute(this.errReader);
            }
            catch (Exception ex) {
                logger.error((Object)("SSH failure: user=[" + this.user + "] auth=[" + this.authInfo + "]"), (Throwable)ex);
                SshException e = new SshException();
                e.initCause(ex);
                throw e;
            }
        }

        public void disconnect() {
            if (this.outReader != null) {
                this.outReader.stop();
            }
            if (this.errReader != null) {
                this.errReader.stop();
            }
            if (this.channel != null) {
                this.exitCode = this.channel.getExitStatus();
                this.channel.disconnect();
            }
            if (this.session != null) {
                this.session.disconnect();
            }
        }

        public int getExitCode() {
            return this.exitCode;
        }
    }

    public static interface SSHExecCallback {
        public void newData(String var1);
    }

    private static class ReaderTask
    implements Runnable {
        ChannelExec channel;
        SSHExecCallback callback;
        InputStream in;
        boolean stop = false;

        ReaderTask(ChannelExec channel, InputStream in, SSHExecCallback callback) {
            this.channel = channel;
            this.callback = callback;
            this.in = in;
        }

        synchronized void stop() {
            this.stop = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            byte[] tmp = new byte[1024];
            while (true) {
                ReaderTask readerTask = this;
                synchronized (readerTask) {
                    if (this.stop) {
                        break;
                    }
                }
                try {
                    int i;
                    while (this.in.available() > 0 && (i = this.in.read(tmp, 0, 1024)) >= 0) {
                        String s = new String(tmp, 0, i);
                        this.callback.newData(s);
                    }
                }
                catch (Exception ex) {
                    break;
                }
                if (this.channel.isClosed()) break;
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
        }
    }

    private static class MyUserInfo
    implements UserInfo {
        String password;

        MyUserInfo(String password) {
            this.password = password;
        }

        public String getPassphrase() {
            return null;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean promptPassphrase(String arg0) {
            return true;
        }

        public boolean promptPassword(String arg0) {
            return true;
        }

        public boolean promptYesNo(String arg0) {
            return true;
        }

        public void showMessage(String arg0) {
        }
    }

    public static class SshException
    extends Exception {
        private static final long serialVersionUID = -7284013737516587531L;
    }

    public static class SshAuthInfo {
        private String password;
        private String keyFile;

        public SshAuthInfo(String password, String keyFile) {
            this.password = password;
            this.keyFile = keyFile;
            if (password == null && keyFile == null) {
                throw new IllegalArgumentException();
            }
        }

        public String toString() {
            return this.password != null ? "password=" + this.password : "keyfile=" + this.keyFile;
        }
    }

    public static class Result {
        public int exitCode;
        public String output;
        public String error;
    }
}

