/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.xenapi;

import com.xensource.xenapi.APIVersion;
import com.xensource.xenapi.Connection;
import com.xensource.xenapi.Event;
import com.xensource.xenapi.Host;
import com.xensource.xenapi.Pool;
import com.xensource.xenapi.Session;
import com.xensource.xenapi.Types;
import com.xensource.xenapi.VM;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.ow2.jasmine.vmm.agent.domain.ServerPool;
import org.ow2.jasmine.vmm.agent.driver.xenapi.XenHost;
import org.ow2.jasmine.vmm.agent.driver.xenapi.XenVMImageStore;
import org.ow2.jasmine.vmm.agent.driver.xenapi.XenVirtualMachine;
import org.ow2.jasmine.vmm.agent.jmx.MBeanObjectNamer;
import org.ow2.jasmine.vmm.agent.main.AgentCommon;
import org.ow2.jasmine.vmm.api.HostMXBean;
import org.ow2.jasmine.vmm.api.VirtualMachineImageStoreMXBean;

public class XenServerPool
extends ServerPool {
    private int port;
    private String user;
    private String password;
    private String master;
    private VirtualMachineImageStoreMXBean imageStore;
    private String sharedStorageRepository;
    private Pool pool;
    private Connection masterCon;
    protected EventCollector eventCollector;

    public XenServerPool(String name, ObjectName objectName, Map<String, String> attributes) throws IllegalArgumentException {
        super(name, objectName, attributes);
        String port = attributes.get("port");
        if (port == null) {
            this.port = 9363;
        } else {
            try {
                this.port = Integer.parseInt(port);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Wrong value for port");
            }
        }
        this.user = attributes.get("user");
        this.password = attributes.get("password");
        this.sharedStorageRepository = attributes.get("sharedStorageRepository");
        if (this.sharedStorageRepository == null) {
            throw new IllegalArgumentException("Missing parameter: sharedStorageRepository");
        }
        this.master = attributes.get("master");
        try {
            this.masterCon = new Connection(new URL("http://" + this.master));
            Session.loginWithPassword((Connection)this.masterCon, (String)this.user, (String)this.password, (String)APIVersion.latest().toString());
            this.eventCollector = new EventCollector(this.masterCon);
            Set pools = Pool.getAll((Connection)this.masterCon);
            for (Pool p : pools) {
                if (!p.getNameLabel(this.masterCon).equals(name)) continue;
                this.pool = p;
            }
            if (this.pool == null) {
                throw new Exception("Pool " + name + " not found.");
            }
            this.initialize();
        }
        catch (Exception ex) {
            XenHost.logger.error((Object)("Failed to establish Xen-API connection with host " + this.master + " with login " + this.user), (Throwable)ex);
        }
    }

    @Override
    public String getHypervisor() {
        return "XenServer";
    }

    public String getSharedStorageRepository() {
        return this.sharedStorageRepository;
    }

    @Override
    public HostMXBean newHost(String hostName, Map<String, String> attributes) throws IllegalArgumentException {
        try {
            HostMXBean host2;
            for (HostMXBean host2 : this.hosts) {
                if (!host2.getHostName().equals(hostName)) continue;
                return host2;
            }
            ObjectName mbeanObjectName = MBeanObjectNamer.makeHostName(this.getPath() + "/" + hostName, hostName);
            host2 = XenHost.newHost(this, mbeanObjectName, hostName, this.user, this.password, this.port, this.masterCon, attributes);
            if (host2 != null) {
                AgentCommon.getMBeanServer().registerMBean(host2, mbeanObjectName);
                this.hosts.add(host2);
                ServerPool.logger.info((Object)("In server pool " + this.servername + ": added Host MBean " + mbeanObjectName));
                if (this.imageStore == null && this.sharedStorageRepository != null) {
                    ObjectName sharedImageStoreName = MBeanObjectNamer.makeVMImageStoreName(this.sharedStorageRepository);
                    try {
                        this.imageStore = new XenVMImageStore(sharedImageStoreName, this.sharedStorageRepository, (XenHost)host2);
                        AgentCommon.getMBeanServer().registerMBean(this.imageStore, sharedImageStoreName);
                    }
                    catch (Exception ex) {
                        ServerPool.logger.error((Object)ex);
                    }
                }
            }
            return host2;
        }
        catch (Exception ex) {
            ServerPool.logger.error((Object)"Failed to add XenHost", (Throwable)ex);
            return null;
        }
    }

    @Override
    public VirtualMachineImageStoreMXBean getVMImageStore() {
        return this.imageStore;
    }

    public void initialize() {
        new Thread(this.eventCollector).start();
    }

    XenHost lookUpHostByVMUuid(String uuid) {
        for (HostMXBean host : this.hosts) {
            XenHost h = (XenHost)host;
            XenVirtualMachine vm = h.lookUpByUuid(uuid);
            if (vm == null) continue;
            return h;
        }
        return null;
    }

    XenHost lookUpHostByUuid(String uuid) {
        for (HostMXBean host : this.hosts) {
            if (!((XenHost)host).getUuid().equals(uuid)) continue;
            return (XenHost)host;
        }
        return null;
    }

    @Override
    public void deleteImageStore() {
        try {
            for (int i = this.imageStore.listVMImageTemplates().size(); i > 0; --i) {
                AgentCommon.getMBeanServer().unregisterMBean(this.imageStore.listVMImageTemplates().get(i - 1).getObjectName());
            }
        }
        catch (Throwable e) {
            ServerPool.logger.error((Object)e);
        }
        try {
            AgentCommon.getMBeanServer().unregisterMBean(this.imageStore.getObjectName());
        }
        catch (Exception e) {
            ServerPool.logger.error((Object)e);
        }
        this.imageStore = null;
    }

    private class EventCollector
    implements Runnable {
        volatile boolean stop = false;
        Connection connection;

        EventCollector(Connection connection) {
            this.connection = connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            HashSet<String> eventClasses = new HashSet<String>();
            eventClasses.add("vm");
            eventClasses.add("host");
            try {
                Event.register((Connection)this.connection, eventClasses);
            }
            catch (Exception ex) {
                logger.error((Object)"Cannot register XenAPI session with event system", (Throwable)ex);
                return;
            }
            while (!this.stop) {
                Set eventSet;
                try {
                    eventSet = Event.next((Connection)this.connection);
                }
                catch (Exception ex) {
                    logger.error((Object)"Cannot retrieve next event", (Throwable)ex);
                    continue;
                }
                EventCollector eventCollector = this;
                synchronized (eventCollector) {
                    block23: for (Event.Record event : eventSet) {
                        Types.VmOperations op;
                        Map operations;
                        Object snapshot = event.snapshot;
                        if (snapshot instanceof VM.Record) {
                            VM.Record vmRecord = (VM.Record)event.snapshot;
                            operations = vmRecord.currentOperations;
                            if (operations.isEmpty()) continue;
                            op = (Types.VmOperations)operations.values().iterator().next();
                            String vmName = vmRecord.isControlDomain != false ? "Domain-0" : vmRecord.nameLabel;
                            switch (event.operation) {
                                case ADD: {
                                    try {
                                        VM vm = VM.getByUuid((Connection)this.connection, (String)vmRecord.uuid);
                                        XenHost h = XenServerPool.this.lookUpHostByUuid(vm.getAffinity(this.connection).getUuid(this.connection));
                                        ObjectName name = MBeanObjectNamer.makeVirtualMachineName(XenServerPool.this.getPath() + "/" + vmName, vmRecord.uuid);
                                        if (AgentCommon.getMBeanServer().isRegistered(name)) continue block23;
                                        XenVirtualMachine xenVM = new XenVirtualMachine(name, h, this.connection, vm, null);
                                        h.addVM(xenVM);
                                        AgentCommon.getMBeanServer().registerMBean(xenVM, name);
                                        h.emitNotification("vm.add", "Created", name);
                                    }
                                    catch (Exception ex) {
                                        logger.error((Object)ex);
                                    }
                                    continue block23;
                                }
                                case DEL: {
                                    XenHost h = XenServerPool.this.lookUpHostByVMUuid(vmRecord.uuid);
                                    XenVirtualMachine vm = h.lookUpByUuid(vmRecord.uuid);
                                    if (vm == null) break;
                                    h.removeVM(vm);
                                    h.emitNotification("vm.del", "Destroyed", vm.getObjectName());
                                    try {
                                        AgentCommon.getMBeanServer().unregisterMBean(vm.getObjectName());
                                    }
                                    catch (Exception ex) {
                                        logger.error((Object)ex);
                                    }
                                    continue block23;
                                }
                                case MOD: {
                                    XenHost h = XenServerPool.this.lookUpHostByVMUuid(vmRecord.uuid);
                                    XenVirtualMachine vm = null;
                                    if (h != null) {
                                        vm = h.lookUpByUuid(vmRecord.uuid);
                                    }
                                    switch (op) {
                                        case CLONE: {
                                            continue block23;
                                        }
                                        case START: 
                                        case CLEAN_SHUTDOWN: 
                                        case HARD_SHUTDOWN: 
                                        case PAUSE: 
                                        case RESUME: {
                                            if (vm == null) break;
                                            vm.updatePowerState(vmRecord.powerState);
                                            continue block23;
                                        }
                                        case POOL_MIGRATE: {
                                            Host dest = vmRecord.residentOn;
                                            try {
                                                if (dest.getUuid(this.connection).equals(h.getUuid())) continue block23;
                                                XenHost dstHost = XenServerPool.this.lookUpHostByUuid(dest.getUuid(this.connection));
                                                h.postMigrateVM(vm, dstHost);
                                                vm.emitNotification("vm.migration", dstHost.getHostName(), vm.getUuid());
                                                continue block23;
                                            }
                                            catch (Exception ex) {
                                                logger.error((Object)ex);
                                            }
                                        }
                                    }
                                    continue block23;
                                }
                            }
                            continue;
                        }
                        if (!(snapshot instanceof Host.Record)) continue;
                        Host.Record hostRecord = (Host.Record)event.snapshot;
                        operations = hostRecord.currentOperations;
                        if (operations.isEmpty()) continue;
                        op = (Types.HostAllowedOperations)operations.values().iterator().next();
                    }
                }
            }
            return;
        }
    }
}

