/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.main;

import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.domain.Domain;
import org.ow2.jasmine.vmm.agent.domain.DomainBuilder;
import org.ow2.jasmine.vmm.agent.driver.Driver;
import org.ow2.jasmine.vmm.agent.driver.DriverFactory;
import org.ow2.jasmine.vmm.agent.jmx.MBeanObjectNamer;
import org.ow2.jasmine.vmm.agent.main.AgentCommon;
import org.ow2.jasmine.vmm.agent.main.AgentControl;
import org.ow2.jasmine.vmm.agent.main.persistence.ConfigurationGeneratorException;
import org.ow2.jasmine.vmm.agent.main.persistence.RessourceConfigurationGenerator;
import org.ow2.jasmine.vmm.api.DomainMXBean;
import org.ow2.jasmine.vmm.api.VMMAgentMXBean;
import org.ow2.jasmine.vmm.api.VMMException;

public class VirtManagerAgent
extends AgentCommon
implements VMMAgentMXBean {
    private static Logger logger = Logger.getLogger(VirtManagerAgent.class);
    static VirtManagerAgent instance;
    private JMXConnectorServer cs;
    Domain rootDomain;

    public static VirtManagerAgent getInstance() {
        return instance;
    }

    @Override
    public DomainMXBean getRootDomain() {
        return this.rootDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtManagerAgent(int port, String managedResourcesFileName) {
        instance = this;
        ObjectName agentName = MBeanObjectNamer.makeAgentName();
        try {
            AgentCommon.mbs.registerMBean(this, agentName);
        }
        catch (Exception ex) {
            logger.fatal((Object)("Cannot register MXBean " + agentName), (Throwable)ex);
            System.exit(1);
        }
        logger.info((Object)("Created VMMAgent MBean " + agentName));
        File managedResourcesFile = new File(AgentControl.vmmHome, "etc" + File.separator + managedResourcesFileName);
        this.rootDomain = DomainBuilder.createManagedResourcesFromXML(managedResourcesFile);
        if (this.rootDomain == null) {
            logger.fatal((Object)"Failed to load resource file");
            System.exit(1);
        }
        try {
            LocateRegistry.createRegistry(port);
        }
        catch (RemoteException ex) {
            logger.warn((Object)("Cannot launch RMI registry on port " + port + ", creating new one"));
            try {
                LocateRegistry.createRegistry(port);
            }
            catch (RemoteException ex2) {
                logger.fatal((Object)"Cannot create RMI registry", (Throwable)ex);
                System.exit(1);
            }
        }
        try {
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:" + port + "/server");
            this.cs = JMXConnectorServerFactory.newJMXConnectorServer(url, null, AgentCommon.mbs);
            logger.info((Object)("Starting RMI connector server with URL \"" + url + "\""));
            this.cs.start();
            logger.info((Object)"VMM agent ready");
        }
        catch (Exception ex) {
            logger.fatal((Object)"Failed to start JMX connector server", (Throwable)ex);
            System.exit(1);
        }
        VirtManagerAgent ex = this;
        synchronized (ex) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        try {
            this.cs.stop();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        logger.info((Object)"VMM agent terminated");
        System.exit(0);
    }

    public synchronized void saveConfiguration() {
        logger.info((Object)"Saving XML configuration...");
        RessourceConfigurationGenerator newXML = null;
        try {
            newXML = new RessourceConfigurationGenerator(AgentControl.vmmHome + File.separator + "etc");
        }
        catch (ConfigurationGeneratorException ex) {
            logger.error((Object)ex);
            return;
        }
        try {
            newXML.generate(this.rootDomain);
            logger.info((Object)"XML Generation OK");
        }
        catch (ConfigurationGeneratorException ex) {
            logger.error((Object)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        VirtManagerAgent virtManagerAgent = this;
        synchronized (virtManagerAgent) {
            this.notifyAll();
        }
    }

    public String[] getServerPoolCreationAttributes(String driverName) throws VMMException {
        Driver driver = DriverFactory.getInstance().newDriver(driverName);
        if (driver == null) {
            throw new VMMException("Unsupported driver " + driverName);
        }
        return driver.getServerPoolCreationAttributes();
    }
}

