/*
 * Decompiled with CFR 0.152.
 */
package com.hyper9.jwbem;

import com.hyper9.jwbem.SWbemServices;
import java.net.UnknownHostException;
import org.jinterop.dcom.common.IJIAuthInfo;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JIClsid;
import org.jinterop.dcom.core.JIComServer;
import org.jinterop.dcom.core.JISession;
import org.jinterop.dcom.core.JIString;
import org.jinterop.dcom.core.JIVariant;
import org.jinterop.dcom.impls.JIObjectFactory;
import org.jinterop.dcom.impls.automation.IJIDispatch;

public class SWbemLocator {
    private static final String SWbemLocatorInterfaceId = "76a6415b-cb41-11d1-8b02-00600806d9b6";
    private static final String SWbemLocatorId = "76a64158-cb41-11d1-8b02-00600806d9b6";
    private IJIAuthInfo credentials = null;
    private JISession session = null;
    private JIComServer server = null;

    public SWbemServices connect(String hostName, String swbemTarget, String namespace, String userName, String password) throws JIException, UnknownHostException {
        this.credentials = new Credentials(userName, password);
        this.session = JISession.createSession((IJIAuthInfo)this.credentials);
        this.session.useSessionSecurity(true);
        this.session.setGlobalSocketTimeout(900000);
        JISystem.setAutoRegisteration((boolean)true);
        IJIDispatch sWbemLocatorDispatch = this.getSWbemLocatorInterface(hostName);
        IJIDispatch svcDispatch = this.getWbemServices(sWbemLocatorDispatch, swbemTarget, namespace);
        return new SWbemServices(svcDispatch, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        if (this.session != null) {
            try {
                JISession.destroySession((JISession)this.session);
            }
            catch (Exception exception) {
            }
            finally {
                this.session = null;
                this.server = null;
            }
        }
    }

    private IJIDispatch getSWbemLocatorInterface(String hostname) throws JIException, UnknownHostException {
        JIClsid classId = JIClsid.valueOf((String)SWbemLocatorId);
        this.server = new JIComServer(classId, hostname, this.session);
        IJIComObject unknown = this.server.createInstance();
        IJIComObject comObject = unknown.queryInterface(SWbemLocatorInterfaceId);
        return (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)comObject.queryInterface("00020400-0000-0000-c000-000000000046"));
    }

    private IJIDispatch getWbemServices(IJIDispatch sWbemLocatorDispatch, String swbemTarget, String namespace) throws JIException {
        Object[] inParams = new Object[]{new JIString(swbemTarget), new JIString(namespace), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), new Integer(0), JIVariant.OPTIONAL_PARAM()};
        JIVariant[] results = sWbemLocatorDispatch.callMethodA("ConnectServer", inParams);
        IJIComObject co = results[0].getObjectAsComObject();
        return (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)co);
    }

    static {
        JISystem.setAutoRegisteration((boolean)true);
        JISystem.setJavaCoClassAutoCollection((boolean)false);
    }

    private class Credentials
    implements IJIAuthInfo {
        private String domain = "";
        private final String userName;
        private final String password;

        public Credentials(String userName, String password) {
            if (userName.contains("@")) {
                String[] parts = userName.split("@");
                this.userName = parts[0];
                this.domain = parts[1];
            } else if (userName.contains("\\")) {
                String[] parts = userName.split("\\\\");
                this.userName = parts[1];
                this.domain = parts[0];
            } else {
                this.userName = userName;
            }
            this.password = password;
        }

        public String getDomain() {
            return this.domain;
        }

        public String getPassword() {
            return this.password;
        }

        public String getUserName() {
            return this.userName;
        }
    }
}

