/*
 * Decompiled with CFR 0.152.
 */
package com.hyper9.jwbem;

import com.hyper9.jwbem.SWbemDispatchObject;
import com.hyper9.jwbem.SWbemMethod;
import com.hyper9.jwbem.SWbemMethodSet;
import com.hyper9.jwbem.SWbemObjectPath;
import com.hyper9.jwbem.SWbemProperty;
import com.hyper9.jwbem.SWbemPropertySet;
import com.hyper9.jwbem.SWbemServices;
import com.hyper9.jwbem.SWbemSetItem;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JIUnsignedByte;
import org.jinterop.dcom.core.JIVariant;
import org.jinterop.dcom.impls.JIObjectFactory;
import org.jinterop.dcom.impls.automation.IJIDispatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWbemObject
extends SWbemDispatchObject
implements SWbemSetItem {
    private SWbemObjectPath objectPath;
    private SWbemPropertySet propSet;
    private SWbemMethodSet methSet;

    public SWbemObject(IJIDispatch objectDispatcher, SWbemServices service) {
        super(objectDispatcher, service);
    }

    public SWbemObjectPath getObjectPath() throws JIException {
        if (this.objectPath != null) {
            return this.objectPath;
        }
        JIVariant variant = this.objectDispatcher.get("Path_");
        IJIComObject co = variant.getObjectAsComObject();
        IJIDispatch dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)co);
        this.objectPath = new SWbemObjectPath(dispatch, this.service);
        return this.objectPath;
    }

    public String getObjectText() throws JIException {
        Object[] inParams = new Object[]{new Integer(0)};
        JIVariant[] results = this.objectDispatcher.callMethodA("GetObjectText_", inParams);
        return results[0].getObjectAsString().getString();
    }

    public SWbemPropertySet getProperties() throws JIException {
        if (this.propSet != null) {
            return this.propSet;
        }
        JIVariant variant = this.objectDispatcher.get("Properties_");
        IJIComObject co = variant.getObjectAsComObject();
        IJIDispatch dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)co);
        this.propSet = new SWbemPropertySet(dispatch, this.service, SWbemProperty.class);
        return this.propSet;
    }

    public SWbemMethodSet getMethods() throws JIException {
        if (this.methSet != null) {
            return this.methSet;
        }
        JIVariant variant = this.objectDispatcher.get("Methods_");
        IJIComObject co = variant.getObjectAsComObject();
        IJIDispatch dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)co);
        this.methSet = new SWbemMethodSet(dispatch, this.service, SWbemMethod.class);
        return this.methSet;
    }

    protected <T> T getProperty(String propertyName, Class<T> clazz) throws UnsupportedOperationException {
        try {
            SWbemProperty prop = (SWbemProperty)this.getProperties().getItem(propertyName);
            if (prop == null) {
                return null;
            }
            if (clazz.isArray()) {
                Class<?> compType = clazz.getComponentType();
                Object pv = prop.getValue();
                if (pv.equals(0)) {
                    return (T)Array.newInstance(compType, 0);
                }
                JIArray jiarr = (JIArray)pv;
                JIVariant[] jivarr = (JIVariant[])jiarr.getArrayInstance();
                Object arr = Array.newInstance(compType, jivarr.length);
                for (int x = 0; x < jivarr.length; ++x) {
                    if (compType == String.class) {
                        Array.set(arr, x, jivarr[x].getObjectAsString2());
                        continue;
                    }
                    if (compType == Short.class || compType == Short.TYPE) {
                        Array.set(arr, x, jivarr[x].getObjectAsShort());
                        continue;
                    }
                    if (compType == Integer.class || compType == Integer.TYPE) {
                        Array.set(arr, x, jivarr[x].getObjectAsInt());
                        continue;
                    }
                    if (compType != Long.class && compType != Long.TYPE) continue;
                    Array.set(arr, x, jivarr[x].getObjectAsLong());
                }
                return (T)arr;
            }
            if (clazz == String.class) {
                return (T)prop.toString();
            }
            if (clazz == Short.class || clazz == Short.TYPE) {
                return (T)new Short(((JIUnsignedByte)prop.getValue()).getValue().shortValue());
            }
            if (clazz == Integer.class || clazz == Integer.TYPE) {
                return (T)prop.getValueAsInteger();
            }
            if (clazz == Long.class || clazz == Long.TYPE) {
                return (T)prop.getValueAsLong();
            }
            if (clazz == Boolean.class) {
                return (T)prop.getValueAsBoolean();
            }
            if (clazz == Date.class) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                String dateString = prop.toString().substring(0, 8);
                return (T)sdf.parse(dateString);
            }
        }
        catch (Throwable e) {
            JISystem.getLogger().log(Level.SEVERE, "Error getting property value", e);
        }
        throw new UnsupportedOperationException("Invalid class type.");
    }
}

