/*
 * Decompiled with CFR 0.152.
 */
package com.hyper9.jwbem;

import com.hyper9.jwbem.SWbemDispatchObject;
import com.hyper9.jwbem.SWbemServices;
import com.hyper9.jwbem.SWbemSetItem;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.core.JIUnsignedByte;
import org.jinterop.dcom.core.JIVariant;
import org.jinterop.dcom.impls.automation.IJIDispatch;

public class SWbemProperty
extends SWbemDispatchObject
implements SWbemSetItem {
    private JIVariant value;
    private String name;
    private Boolean isArray;

    public SWbemProperty(IJIDispatch objectDispatcher, SWbemServices service) {
        super(objectDispatcher, service);
        try {
            this.value = this.objectDispatcher.get("Value");
        }
        catch (JIException ex) {
            this.value = null;
        }
    }

    public String getName() throws JIException {
        if (this.name != null) {
            return this.name;
        }
        this.name = this.objectDispatcher.get("Name").getObjectAsString2();
        return this.name;
    }

    public boolean isArray() throws JIException {
        if (this.isArray != null) {
            return this.isArray;
        }
        this.isArray = this.objectDispatcher.get("IsArray").getObjectAsBoolean();
        return this.isArray;
    }

    public Object getValue() throws JIException {
        return this.value.getObject();
    }

    public Integer getValueAsInteger() throws JIException {
        switch (this.value.getType()) {
            case 8: {
                return Integer.parseInt(this.value.getObjectAsString2());
            }
            case 3: {
                return this.value.getObjectAsInt();
            }
        }
        return null;
    }

    public Long getValueAsLong() throws JIException {
        switch (this.value.getType()) {
            case 8: {
                return Long.parseLong(this.value.getObjectAsString2());
            }
            case 3: {
                return new Long(this.value.getObjectAsInt());
            }
            case 20: {
                return this.value.getObjectAsLong();
            }
        }
        return null;
    }

    public Boolean getValueAsBoolean() throws JIException {
        return this.value.getObjectAsBoolean();
    }

    private String getValueAsString() throws JIException {
        switch (this.value.getType()) {
            case 8: {
                return this.value.getObjectAsString2();
            }
            case 11: {
                return String.valueOf(this.value.getObjectAsBoolean());
            }
            case 2: {
                return String.valueOf(this.value.getObjectAsShort());
            }
            case 3: {
                return String.valueOf(this.value.getObjectAsInt());
            }
            case 1: {
                return null;
            }
            case 17: {
                return ((JIUnsignedByte)this.value.getObject()).getValue().toString();
            }
        }
        return "<type: " + String.valueOf(this.value.getType()) + ", flag: " + String.valueOf(this.value.getFlag()) + ", value: " + this.value.toString() + ">";
    }

    public String toString() {
        try {
            return this.getValueAsString();
        }
        catch (Exception e) {
            return null;
        }
    }
}

