/*
 * Decompiled with CFR 0.152.
 */
package com.hyper9.jwbem;

import com.hyper9.jwbem.SWbemDispatchObject;
import com.hyper9.jwbem.SWbemObject;
import com.hyper9.jwbem.SWbemServices;
import com.hyper9.jwbem.SWbemSetItem;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JIString;
import org.jinterop.dcom.core.JIVariant;
import org.jinterop.dcom.impls.JIObjectFactory;
import org.jinterop.dcom.impls.automation.IJIDispatch;
import org.jinterop.dcom.impls.automation.IJIEnumVariant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWbemSet<T extends SWbemSetItem>
extends SWbemDispatchObject
implements Iterable<T> {
    private Integer size;
    private Class<T> clazz;

    private SWbemSet(IJIDispatch objectDispatcher, SWbemServices service) {
        super(objectDispatcher, service);
    }

    public SWbemSet(IJIDispatch objectDispatcher, SWbemServices service, Class<T> clazz) {
        this(objectDispatcher, service);
        this.clazz = clazz;
    }

    @Override
    public Iterator<T> iterator() {
        try {
            return new SWbemSetIterator(this.objectDispatcher, this.service);
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getSize() {
        if (this.size != null) {
            return this.size;
        }
        try {
            JIVariant jiCount = this.objectDispatcher.get("Count");
            this.size = jiCount.getObjectAsInt();
        }
        catch (JIException ex) {
            this.size = 0;
        }
        return this.size;
    }

    public T[] toArray() {
        SWbemSetItem[] arr = (SWbemSetItem[])Array.newInstance(this.clazz, this.getSize());
        int x = 0;
        Iterator<T> iter = this.iterator();
        while (iter.hasNext()) {
            arr[x] = (SWbemSetItem)iter.next();
            ++x;
        }
        return arr;
    }

    public IJIDispatch[] toNativeArray() {
        IJIDispatch[] arr = new IJIDispatch[this.getSize()];
        int x = 0;
        Iterator<T> iter = this.iterator();
        while (iter.hasNext()) {
            arr[x] = ((SWbemObject)iter.next()).getObjectDispatcher();
            ++x;
        }
        return arr;
    }

    public T getItem(String itemName) throws Exception {
        try {
            Object[] inParams = new Object[]{new JIString(itemName), new Integer(0)};
            JIVariant[] results = this.objectDispatcher.callMethodA("Item", inParams);
            IJIComObject prop = results[0].getObjectAsComObject();
            IJIDispatch dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)prop);
            Constructor<T> ctor = this.clazz.getConstructor(IJIDispatch.class, SWbemServices.class);
            SWbemSetItem item = (SWbemSetItem)ctor.newInstance(dispatch, this.service);
            return (T)item;
        }
        catch (JIException e) {
            if (e.getErrorCode() == -2147352567) {
                return null;
            }
            throw e;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SWbemSetIterator
    extends SWbemDispatchObject
    implements Iterator<T> {
        private int count;
        private IJIEnumVariant enumerator;

        public SWbemSetIterator(IJIDispatch objectDispatcher, SWbemServices service) throws JIException {
            super(objectDispatcher, service);
            this.count = 0;
            this.enumerator = null;
            JIVariant jiCount = this.objectDispatcher.get("Count");
            this.count = jiCount.getObjectAsInt();
            JIVariant variant = this.objectDispatcher.get("_NewEnum");
            IJIComObject co = variant.getObjectAsComObject();
            co = co.queryInterface("00020404-0000-0000-C000-000000000046");
            this.enumerator = (IJIEnumVariant)JIObjectFactory.narrowObject((IJIComObject)co);
        }

        @Override
        public boolean hasNext() {
            return this.count > 0;
        }

        @Override
        public T next() {
            try {
                if (this.hasNext()) {
                    --this.count;
                    Object[] values = this.enumerator.next(1);
                    JIArray array = (JIArray)values[0];
                    Object[] arrayObj = (Object[])array.getArrayInstance();
                    IJIComObject co = ((JIVariant)arrayObj[0]).getObjectAsComObject();
                    IJIDispatch dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)co);
                    Constructor ctor = SWbemSet.this.clazz.getConstructor(IJIDispatch.class, SWbemServices.class);
                    SWbemSetItem item = (SWbemSetItem)ctor.newInstance(dispatch, this.service);
                    return item;
                }
                throw new NoSuchElementException();
            }
            catch (Exception ex) {
                return null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

