/*
 * Decompiled with CFR 0.152.
 */
package com.hyper9.jwbem.msvm.networking;

import com.hyper9.jwbem.SWbemMethod;
import com.hyper9.jwbem.SWbemObject;
import com.hyper9.jwbem.SWbemObjectSet;
import com.hyper9.jwbem.SWbemServices;
import com.hyper9.jwbem.msvm.MsvmObject;
import com.hyper9.jwbem.msvm.networking.MsvmActiveConnection;
import com.hyper9.jwbem.msvm.networking.MsvmSwitchPort;
import com.hyper9.jwbem.msvm.networking.MsvmVirtualSwitch;
import com.hyper9.jwbem.msvm.networking.MsvmVmLANEndpoint;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JIString;
import org.jinterop.dcom.core.JIVariant;
import org.jinterop.dcom.impls.JIObjectFactory;
import org.jinterop.dcom.impls.automation.IJIDispatch;

public class MsvmVirtualSwitchManagementService
extends MsvmObject {
    private SWbemMethod disconnectSwitchPort;
    private SWbemMethod connectSwitchPort;
    private SWbemMethod createSwitchPort;
    private SWbemMethod deleteSwitchPort;

    public MsvmVirtualSwitchManagementService(IJIDispatch objectDispatcher, SWbemServices service) {
        super(objectDispatcher, service);
    }

    public static MsvmVirtualSwitchManagementService getManagementService(SWbemServices service) throws Exception {
        String wql = "SELECT * FROM Msvm_VirtualSwitchManagementService";
        SWbemObjectSet<MsvmVirtualSwitchManagementService> objSetMgmtSvc = service.execQuery("SELECT * FROM Msvm_VirtualSwitchManagementService", MsvmVirtualSwitchManagementService.class);
        int size = objSetMgmtSvc.getSize();
        if (size != 1) {
            throw new Exception("There should be exactly 1 Msvm_VirtualSwitchManagementService");
        }
        MsvmVirtualSwitchManagementService mgmtSvc = (MsvmVirtualSwitchManagementService)objSetMgmtSvc.iterator().next();
        return mgmtSvc;
    }

    public MsvmActiveConnection connectSwitchPort(MsvmSwitchPort switchPort, MsvmVmLANEndpoint lanEndPoint) throws JIException {
        if (this.connectSwitchPort == null) {
            for (SWbemMethod m : super.getMethods()) {
                if (!m.getName().equals("ConnectSwitchPort")) continue;
                this.connectSwitchPort = m;
            }
        }
        String switchPortPath = switchPort.getObjectPath().getPath();
        String lanEndPointPath = lanEndPoint.getObjectPath().getPath();
        SWbemObject inParams = this.connectSwitchPort.getInParameters();
        inParams.getObjectDispatcher().put("SwitchPort", new JIVariant(new JIString(switchPortPath)));
        inParams.getObjectDispatcher().put("LANEndpoint", new JIVariant(new JIString(lanEndPointPath)));
        Object[] methodParams = new Object[]{new JIString("ConnectSwitchPort"), new JIVariant((IJIComObject)inParams.getObjectDispatcher()), new Integer(0), JIVariant.NULL()};
        JIVariant[] results = this.objectDispatcher.callMethodA("ExecMethod_", methodParams);
        JIVariant outParamsVar = results[0];
        IJIComObject co = outParamsVar.getObjectAsComObject();
        IJIDispatch outParamsDisp = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)co);
        JIVariant acVar = outParamsDisp.get("ActiveConnection");
        String acPath = acVar.getObjectAsString2();
        if (acPath.equals("")) {
            return null;
        }
        return new MsvmActiveConnection(null, this.service);
    }

    public void disconnectSwitchPort(MsvmSwitchPort toDisconnect) throws JIException {
        if (this.disconnectSwitchPort == null) {
            for (SWbemMethod m : super.getMethods()) {
                if (!m.getName().equals("DisconnectSwitchPort")) continue;
                this.disconnectSwitchPort = m;
            }
        }
        String toDisconnectPath = toDisconnect.getObjectPath().getPath();
        SWbemObject inParams = this.disconnectSwitchPort.getInParameters();
        inParams.getObjectDispatcher().put("SwitchPort", new JIVariant(new JIString(toDisconnectPath)));
        Object[] methodParams = new Object[]{new JIString("DisconnectSwitchPort"), new JIVariant((IJIComObject)inParams.getObjectDispatcher()), new Integer(0), JIVariant.NULL()};
        this.objectDispatcher.callMethodA("ExecMethod_", methodParams);
    }

    public void deleteSwitchPort(MsvmSwitchPort toDelete) throws JIException {
        if (this.deleteSwitchPort == null) {
            for (SWbemMethod m : super.getMethods()) {
                if (!m.getName().equals("DeleteSwitchPort")) continue;
                this.deleteSwitchPort = m;
            }
        }
        String toDeletePath = toDelete.getObjectPath().getPath();
        SWbemObject inParams = this.deleteSwitchPort.getInParameters();
        inParams.getObjectDispatcher().put("SwitchPort", new JIVariant(new JIString(toDeletePath)));
        Object[] methodParams = new Object[]{new JIString("DeleteSwitchPort"), new JIVariant((IJIComObject)inParams.getObjectDispatcher()), new Integer(0), JIVariant.NULL()};
        this.objectDispatcher.callMethodA("ExecMethod_", methodParams);
    }

    public MsvmSwitchPort createSwitchPort(MsvmVirtualSwitch vswitch, String name, String friendlyName, String scope) throws Exception {
        if (this.createSwitchPort == null) {
            for (SWbemMethod m : super.getMethods()) {
                if (!m.getName().equals("CreateSwitchPort")) continue;
                this.createSwitchPort = m;
            }
        }
        String vswitchPath = vswitch.getObjectPath().getPath();
        SWbemObject inParams = this.createSwitchPort.getInParameters();
        inParams.getObjectDispatcher().put("VirtualSwitch", new JIVariant(new JIString(vswitchPath)));
        inParams.getObjectDispatcher().put("Name", new JIVariant(new JIString(name)));
        inParams.getObjectDispatcher().put("FriendlyName", new JIVariant(new JIString(friendlyName)));
        inParams.getObjectDispatcher().put("ScopeOfResidence", new JIVariant(new JIString(scope)));
        Object[] methodParams = new Object[]{new JIString("CreateSwitchPort"), new JIVariant((IJIComObject)inParams.getObjectDispatcher()), new Integer(0), JIVariant.NULL()};
        JIVariant[] results = this.objectDispatcher.callMethodA("ExecMethod_", methodParams);
        JIVariant outParamsVar = results[0];
        IJIComObject co = outParamsVar.getObjectAsComObject();
        IJIDispatch outParamsDisp = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)co);
        JIVariant cspVar = outParamsDisp.get("CreatedSwitchPort");
        String cspPath = cspVar.getObjectAsString2();
        if (cspPath.equals("")) {
            return null;
        }
        MsvmSwitchPort sp = MsvmSwitchPort.getByName(this.service, MsvmSwitchPort.class, name);
        return sp;
    }
}

