/*
 * Decompiled with CFR 0.152.
 */
package com.hyper9.jwbem.msvm.virtualsystem;

import com.hyper9.jwbem.SWbemMethod;
import com.hyper9.jwbem.SWbemObject;
import com.hyper9.jwbem.SWbemObjectSet;
import com.hyper9.jwbem.SWbemServices;
import com.hyper9.jwbem.SWbemSet;
import com.hyper9.jwbem.msvm.MsvmObject;
import com.hyper9.jwbem.msvm.networking.MsvmSyntheticEthernetPort;
import com.hyper9.jwbem.msvm.virtualsystem.MsvmVirtualSystemSettingData;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JIString;
import org.jinterop.dcom.core.JIVariant;
import org.jinterop.dcom.impls.automation.IJIDispatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MsvmComputerSystem
extends MsvmObject {
    private SWbemMethod requestStateChange;

    public MsvmComputerSystem(IJIDispatch objectDispatcher, SWbemServices service) {
        super(objectDispatcher, service);
    }

    public int requestStateChange(int requestedState) throws Exception {
        if (this.requestStateChange == null) {
            for (SWbemMethod m : super.getMethods()) {
                if (!m.getName().equals("RequestStateChange")) continue;
                this.requestStateChange = m;
            }
        }
        SWbemObject inParams = this.requestStateChange.getInParameters();
        inParams.getObjectDispatcher().put("RequestedState", new JIVariant(requestedState));
        inParams.getObjectDispatcher().put("TimeoutPeriod", JIVariant.NULL());
        Object[] methodParams = new Object[]{new JIString("RequestStateChange"), new JIVariant((IJIComObject)inParams.getObjectDispatcher()), new Integer(0), JIVariant.NULL()};
        this.objectDispatcher.callMethodA("ExecMethod_", methodParams);
        return 0;
    }

    public SWbemObjectSet<MsvmVirtualSystemSettingData> getSettingData() throws Exception {
        String path = super.getObjectPath().getPath();
        String wmiClass = "Msvm_VirtualSystemSettingData";
        String format = "ASSOCIATORS OF {%s} WHERE ResultClass=%s";
        String wql = String.format(format, path, wmiClass);
        SWbemObjectSet<MsvmVirtualSystemSettingData> objSetSD = super.getService().execQuery(wql, MsvmVirtualSystemSettingData.class);
        return objSetSD;
    }

    public int getEnabledState() {
        return super.getProperty("EnabledState", Integer.class);
    }

    public SWbemSet<MsvmSyntheticEthernetPort> getSyntheticEthernetPorts() throws Exception {
        String path = super.getObjectPath().getPath();
        String wmiClass = "Msvm_SyntheticEthernetPort";
        String format = "ASSOCIATORS OF {%s} WHERE ResultClass=%s";
        String wql = String.format(format, path, wmiClass);
        SWbemObjectSet<MsvmSyntheticEthernetPort> objSetSEP = super.getService().execQuery(wql, MsvmSyntheticEthernetPort.class);
        return objSetSEP;
    }

    public int getHealthState() {
        return super.getProperty("HealthState", Integer.class);
    }
}

