/*
 * Decompiled with CFR 0.152.
 */
package com.hyper9.jwbem.msvm.virtualsystemmanagement;

import com.hyper9.jwbem.SWbemMethod;
import com.hyper9.jwbem.SWbemObject;
import com.hyper9.jwbem.SWbemObjectSet;
import com.hyper9.jwbem.SWbemServices;
import com.hyper9.jwbem.msvm.MsvmObject;
import com.hyper9.jwbem.msvm.virtualsystem.MsvmSummaryInformation;
import com.hyper9.jwbem.msvm.virtualsystem.MsvmVirtualSystemSettingData;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JIString;
import org.jinterop.dcom.core.JIVariant;
import org.jinterop.dcom.impls.JIObjectFactory;
import org.jinterop.dcom.impls.automation.IJIDispatch;

public class MsvmVirtualSystemManagementService
extends MsvmObject {
    private SWbemMethod getSummaryInformation;

    public MsvmVirtualSystemManagementService(IJIDispatch dispatch, SWbemServices service) {
        super(dispatch, service);
    }

    public static MsvmVirtualSystemManagementService getManagementService(SWbemServices service) throws Exception {
        String wql = "SELECT * FROM Msvm_VirtualSystemManagementService";
        SWbemObjectSet<MsvmVirtualSystemManagementService> objSetMgmtSvc = service.execQuery("SELECT * FROM Msvm_VirtualSystemManagementService", MsvmVirtualSystemManagementService.class);
        int size = objSetMgmtSvc.getSize();
        if (size != 1) {
            throw new Exception("There should be exactly 1 Msvm_VirtualSystemManagementService");
        }
        MsvmVirtualSystemManagementService mgmtSvc = (MsvmVirtualSystemManagementService)objSetMgmtSvc.iterator().next();
        return mgmtSvc;
    }

    public MsvmSummaryInformation getSummaryInformation(MsvmVirtualSystemSettingData[] settingData, Integer[] requestedInformation) throws Exception {
        if (this.getSummaryInformation == null) {
            for (SWbemMethod m : super.getMethods()) {
                if (!m.getName().equals("GetSummaryInformation")) continue;
                this.getSummaryInformation = m;
            }
        }
        JIString[] sdpaths = new JIString[settingData.length];
        for (int x = 0; x < sdpaths.length; ++x) {
            String path = settingData[x].getObjectPath().getPath();
            sdpaths[x] = new JIString(path);
        }
        SWbemObject inParams = this.getSummaryInformation.getInParameters();
        inParams.getObjectDispatcher().put("SettingData", new JIVariant(new JIArray((Object)sdpaths)));
        inParams.getObjectDispatcher().put("RequestedInformation", new JIVariant(new JIArray((Object)requestedInformation)));
        Object[] methodParams = new Object[]{new JIString("GetSummaryInformation"), new JIVariant((IJIComObject)inParams.getObjectDispatcher()), new Integer(0), JIVariant.NULL()};
        JIVariant[] results = this.objectDispatcher.callMethodA("ExecMethod_", methodParams);
        JIVariant outParamsVar = results[0];
        IJIComObject co = outParamsVar.getObjectAsComObject();
        IJIDispatch outParamsDisp = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)co);
        JIVariant summInfoVars = outParamsDisp.get("SummaryInformation");
        JIArray summInfoJIArr = summInfoVars.getObjectAsArray();
        JIVariant[] summInfoJIVarArr = (JIVariant[])summInfoJIArr.getArrayInstance();
        if (summInfoJIVarArr.length != 1) {
            throw new UnsupportedOperationException("More than one summary.");
        }
        IJIComObject summInfoCo = summInfoJIVarArr[0].getObjectAsComObject();
        IJIDispatch summInfoDisp = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)summInfoCo);
        return new MsvmSummaryInformation(summInfoDisp, this.service);
    }
}

