#!/bin/sh

cygwin=false;
case "`uname`" in
  CYGWIN*) cygwin=true;
esac

if [ -z $VMM_HOME ]
then
  savewd=`pwd`
  cd `dirname $0`
  zdir=`pwd`
  cd $savewd
  VMM_HOME=`dirname $zdir`
  export VMM_HOME
fi



if [ -z "$JAVA_HOME" ]
then
    JAVA=java
else
    JAVA="$JAVA_HOME/bin/java"
fi

CLASSPATH=$VMM_HOME/etc:$VMM_HOME/lib:$VMM_HOME/lib/vmmagent.jar


if $cygwin; then
  CLASSPATH=`cygpath --path -w $CLASSPATH`
  VMM_HOME=`cygpath --path -w $VMM_HOME`
fi

JAVA_OPTS=-Dvmm.home="$VMM_HOME"

MODE=
ARGS=
START_OPTS=

while [ "$#" -gt 0 ]
  do case "$1" in
    start)
      MODE=start
      ;;
    stop)
      MODE=stop
      ;;
    *)
      ARGS="$ARGS $1"
      ;;
  esac
  shift
done

case "$MODE" in
  start)
    START_OPTS="-start"
    BACKGROUND=true;
    ;;
  stop)
    START_OPTS="-stop"
    ;;
  *)
    echo "Usage: $0 start | stop"
 	exit 1
    ;;
esac


if [ -n $BACKGROUND ]; then
"$JAVA"  $JAVA_OPTS -cp $CLASSPATH org.ow2.jasmine.vmm.agent.main.AgentControl $START_OPTS $ARGS &
else
"$JAVA"  $JAVA_OPTS -cp $CLASSPATH org.ow2.jasmine.vmm.agent.main.AgentControl $START_OPTS $ARGS
fi
