/* libvirt test program */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

//#include </usr/scripts/temp/SondesIoEth.h>
#include "SondesIoEth.h"

/*---------------------------------------------------------------------------
** CONSTANTES LOCALES
**---------------------------------------------------------------------------
*/

/*---------------------------------------------------------------------------
** MACROS LOCALES
**---------------------------------------------------------------------------
*/


/*---------------------------------------------------------------------------
** TYPES LOCAUX
**---------------------------------------------------------------------------
*/


/*---------------------------------------------------------------------------
** VARIABLES LOCALES
**---------------------------------------------------------------------------
*/


/*---------------------------------------------------------------------------
** VARIABLES GLOBALES
**---------------------------------------------------------------------------
*/


/*---------------------------------------------------------------------------
** PROTOTYPES DES FONCTIONS LOCALES
**---------------------------------------------------------------------------
*/
static void preparation( char *element,
             		 char *target,
             		 char *info,
             		 sondeXML_t *p_tabRecherhe );

static void trouveElement( xmlNode * a_node, 
			   sondeXML_t *p_tabRecherhe );


static void print_element_names( xmlNode * a_node, 
				 sondeXML_t *p_tabRecherhe);

/*---------------------------------------------------------------------------
** FONCTIONS LOCALES
**---------------------------------------------------------------------------
*/


static void preparation( char *element,
	     		 char *target,
	     		 char *info,
	     		 sondeXML_t *p_tabRecherhe )
{
    /* Initialisation structure */
    memset( (void *) p_tabRecherhe, 0x00, sizeof (sondeXML_t) );
   
   strcpy( p_tabRecherhe->element, element );
   strcpy( p_tabRecherhe->target, target );
   strcpy( p_tabRecherhe->info, info );
   
   return;
}


static void trouveElement( xmlNode * a_node, 
			   sondeXML_t *p_tabRecherhe )
{
    xmlNode *cur_node = NULL; 
    xmlChar *str;

    for (cur_node = a_node; cur_node; cur_node = cur_node->next) {
        if (cur_node->type == XML_ELEMENT_NODE) {
	    if(!xmlStrcmp(cur_node->name, p_tabRecherhe->target)) {
            	str = xmlGetProp(cur_node,p_tabRecherhe->info);
		strcpy( p_tabRecherhe->tabValeur[p_tabRecherhe->nbrValeur], str );
		p_tabRecherhe->nbrValeur++;
                //printf("getprop %s\n", str);
		free(str);
		return;
	    }
        }

        trouveElement(cur_node->children, p_tabRecherhe);
    }
}

static void print_element_names( xmlNode * a_node, 
				 sondeXML_t *p_tabRecherhe)
{
    xmlChar *str;
    xmlNode *cur_node = NULL;
    xmlChar *contenu = NULL;

    for (cur_node = a_node; cur_node; cur_node = cur_node->next) {
        if (cur_node->type == XML_ELEMENT_NODE) {
	    if(!xmlStrcmp(cur_node->name, p_tabRecherhe->element)) {
            	//printf("node type: Element, name: %s\n", cur_node->name);
		trouveElement(cur_node->children, p_tabRecherhe);
	    }
        }

        print_element_names(cur_node->children, p_tabRecherhe);
    }
}



/*---------------------------------------------------------------------------
** FONCTIONS GLOBALES
**---------------------------------------------------------------------------
*/

/*---------------------------------------------------------------------------
**
** FONCTION : SondeIoEth
**
** DESCRIPTION :
**      Cette fonction permet de recuperer a partir d'un XML les
**       informations sur les noms et le nombre des disques d'une
**       VM ainsi que le nom des interfaces reseau
**
** PARAMETRES D'ENTREE :
**      virDomainPtr     dom
**      sondeXML_t       *p_tabDisque
**      sondeXML_t       *p_tabInterface
**
** PARAMETRES DE SORTIE :
**      Mise a jour des structures sondeXML_t
**
** VALEURS DE RETOUR :
**      0 : OK
**      1 : erreur
**---------------------------------------------------------------------------
*/
extern int SondeIoEth(  virDomainPtr     dom,
			sondeXML_t       *p_tabDisque,
			sondeXML_t       *p_tabInterface )

{
   int			i;
   char 		*xml;
   size_t 		taille;
   xmlDocPtr 		doc; 
   xmlNode 		*root_element = NULL;


   xml = virDomainGetXMLDesc(dom, 0);
   if (!xml) {
      fprintf(stderr, "Failed to get domain description\n");
      return 1;
   }
//printf("virDomainGetXMLDesc OK\n");
   taille = strlen( (const char *) xml );

   doc = xmlReadMemory(xml, taille, "noname.xml", NULL, 0);
    if (doc == NULL) {
        fprintf(stderr, "Failed to parse document\n");
	return 2;
    }
//printf("xmlReadMemory OK\n");
    
    preparation( "disk", "target", "dev", p_tabDisque );

    /*Get the root element node */
    root_element = xmlDocGetRootElement(doc);
    print_element_names(root_element, p_tabDisque);

    preparation( "interface", "target", "dev", p_tabInterface );

    /*Get the root element node */
    root_element = xmlDocGetRootElement(doc);
    print_element_names(root_element, p_tabInterface);

    xmlFreeDoc(doc);
    free(xml);
 
/*
    printf( "\nDisque :" );
    for( i=0; i<p_tabDisque->nbrValeur; i++)
	printf( " %s ", p_tabDisque->tabValeur[i] );

    printf( "\nInterface :" );
    for( i=0; i<p_tabInterface->nbrValeur; i++) {
	printf( " %s ", p_tabInterface->tabValeur[i] );
    }
*/

   //printf( "\n\n" );
   return 0;
}

