/*---------------------------------------------------------------------------
**
** FICHIER : SondesIoEth.h
**
** AUTEUR : %created_by: cbo %
**
** DESCRIPTION :
**
**---------------------------------------------------------------------------
*/

/*---------------------------------------------------------------------------
** INCLUDES SYSTEMES
**---------------------------------------------------------------------------
*/
#include <libvirt/libvirt.h>
#include <libxml/parser.h>
#include <libxml/tree.h>


/*---------------------------------------------------------------------------
** INCLUDES APPLICATIFS
**---------------------------------------------------------------------------
*/

/*---------------------------------------------------------------------------
** CONSTANTES GLOBALES
**---------------------------------------------------------------------------
*/
/* Taille max d'une chaine de caractere de recherhce */
#define		MAX_TAILLE_ELEMENT	20

#define		TAILLE_MAX_VALEUR	80
#define		NBR_MAX_ELEMENT		50

/*---------------------------------------------------------------------------
** MACROS GLOBALES
**---------------------------------------------------------------------------
*/

/*---------------------------------------------------------------------------
** TYPES GLOBAUX
**---------------------------------------------------------------------------
*/


/*
** AUDG_option_t
**
*/
typedef struct
{
    char	element[ MAX_TAILLE_ELEMENT ];	/* element recherche */
    char	target[ MAX_TAILLE_ELEMENT ];	/* cible à recuperer */
    char	info[ MAX_TAILLE_ELEMENT ];	/* Information a extraire */
    int		nbrValeur;
    char	tabValeur[NBR_MAX_ELEMENT][ TAILLE_MAX_VALEUR ];	/* Information a extraire */
} sondeXML_t;

/*---------------------------------------------------------------------------
** VARIABLES GLOBALES
**---------------------------------------------------------------------------
*/

/* DEBUT VAR */

/* FIN VAR */




/*---------------------------------------------------------------------------
** FONCTIONS GLOBALES
**---------------------------------------------------------------------------
*/

/*---------------------------------------------------------------------------
**
** FONCTION : SondeIoEth
**
** DESCRIPTION :
**      Cette fonction permet de recuperer a partir d'un XML les
**       informations sur les noms et le nombre des disques d'une
**	 VM ainsi que le nom des interfaces reseau
**
** PARAMETRES D'ENTREE :
**      virDomainPtr     dom
**	sondeXML_t       *p_tabDisque
**	sondeXML_t       *p_tabInterface
**
** PARAMETRES DE SORTIE :
**      Mise a jour des structures sondeXML_t
**
** VALEURS DE RETOUR :
**      0 : OK
**	1 : erreur
**---------------------------------------------------------------------------
*/
extern int SondeIoEth(  virDomainPtr     dom,
                        sondeXML_t       *p_tabDisque,
                        sondeXML_t       *p_tabInterface );


#ifdef __cplusplus
extern "C" {
#endif
    
/* DEBUT PROTO */

/* FIN PROTO */

#ifdef __cplusplus
}
#endif


/* fin de fichier */

