/*---------------------------------------------------------------------------
**
** FICHIER : Sondes.h
**
** AUTEUR : %created_by: christ %
**
** DESCRIPTION :
**
**---------------------------------------------------------------------------
*/

/*---------------------------------------------------------------------------
** INCLUDES SYSTEMES
**---------------------------------------------------------------------------
*/
#include <libvirt/libvirt.h>
#include <libxml/parser.h>
#include <libxml/tree.h>

/*---------------------------------------------------------------------------
** INCLUDES APPLICATIFS
**---------------------------------------------------------------------------
*/
//#include </usr/scripts/temp/SondesIoEth.h>
#include "SondesIoEth.h"

/*---------------------------------------------------------------------------
** CONSTANTES GLOBALES
**---------------------------------------------------------------------------
*/
/* Nombre d'arguments max en entree de programme */
#define		MAX_ARGUMENTS	7

/* Taille max du nom d'une VM */
#define		TAILLE_MAX_VM	40

/* Nombre de VM maxi */
#define		NBR_MAX_VM	100

/* Taille max du nom d'un disque */
#define		TAILLE_DEV	15

/*---------------------------------------------------------------------------
** MACROS GLOBALES
**---------------------------------------------------------------------------
*/

/*---------------------------------------------------------------------------
** TYPES GLOBAUX
**---------------------------------------------------------------------------
*/
typedef struct
{
    sondeXML_t			SondeIO;	/* IO disque pour chaque disques de chaque VM */
    int				nbrDisk;	/* Nombre de device pour une VM */
    virDomainBlockStatsPtr	p_StatIO;	/* stat IO disque pour chaque disque d'une VM */
} sondeIOdisk_t;

/*--------------------------------------------
struct virDomainBlockStatsStruct{
	long long	rd_req	: number of read requests
	long long	rd_bytes	: number of read bytes
	long long	wr_req	: number of write requests
	long long	wr_bytes	: number of written bytes
	long long	errs	: In Xen this returns the mysterious 'oo_req'.
}
------------------------------------------------
*/

typedef struct
{
    sondeXML_t			SondeEth;	/* IO reseau pour chaque disques de chaque VM */
    int				nbrEth;		/* Nombre de device pour une VM */
    virDomainInterfaceStatsPtr	p_StatEth;	/* stat IO disque pour chaque disque d'une VM */
} sondeIOEth_t;

/*--------------------------------------------
struct virDomainInterfaceStatsStruct{
	long long	rx_bytes
	long long	rx_packets
	long long	rx_errs
	long long	rx_drop
	long long	tx_bytes
	long long	tx_packets
	long long	tx_errs
	long long	tx_drop
}
-----------------------------------------------
*/
typedef struct
{
    sondeIOdisk_t	SondeVMIOAvant;		/* IO disque pour chaque VM */
    sondeIOdisk_t	SondeVMIOApres;		/* IO disque pour chaque VM */
} sondeDisk_t;

typedef struct
{
    sondeIOEth_t	SondeVMEthAvant;		/* IO reseau pour chaque VM */
    sondeIOEth_t	SondeVMEthApres;		/* IO reseau pour chaque VM */
} sondeEth_t;



/*--------------------------------------------
struct virDomainInfo{
	unsigned char		state	: the running state, one of virDomainState
	unsigned long		maxMem	: the maximum memory in KBytes allowed
	unsigned long		memory	: the memory in KBytes used by the domain
	unsigned short		nrVirtCpu	: the number of virtual CPUs for the domain
	unsigned long long	cpuTime	: the CPU time used in nanoseconds
}
-----------------------------------------------
*/

typedef struct
{
    int			tabidVM[NBR_MAX_VM];	/* Tableau des identifiants */
    int			tailleId;		/* taille du tableau */
    int			nbrVM;			/* nbre de VM */
    sondeDisk_t		*SondeVMIO;		/* IO disque pour chaque VM entre deux intevals */
    sondeEth_t		*SondeVMEth;		/* IO reseau pour chaque VM entre deux intevals */
    virDomainPtr	*tabDomPtr;		/* adresse domaine */
    virDomainInfo       *tabInfoVMavant;	/* Remontee d'infos pour chaque VM au moment t   */
    virDomainInfo       *tabInfoVMapres;	/* Remontee d'infos pour chaque VM au moment t+1 */
    
} InfoAll_t;

/*
** AUDG_option_t
**
*/
typedef struct
{
    int		IdBareMetal;			/* Identiant dom0 */
    char	MachVirt[ TAILLE_MAX_VM ];	/* nom machine virtuelle */
    int		IdVM;				/* Identifiant VM */
    int		nbrIdVM;			/* nombre de VM */
    int		Interval;			/* Interval entre 2 mesures */
    int		Iterations;			/* nbre d'iterations */
    int		All;				/* type d'info demande */
    int		typeInfo;
    InfoAll_t	InfoAll;			/* info des VMs */
} InfoMesure_t;

/*---------------------------------------------------------------------------
** VARIABLES GLOBALES
**---------------------------------------------------------------------------
*/

/* DEBUT VAR */

/* FIN VAR */




/*---------------------------------------------------------------------------
** FONCTIONS GLOBALES
**---------------------------------------------------------------------------
*/

#ifdef __cplusplus
extern "C" {
#endif
    
/* DEBUT PROTO */

/* FIN PROTO */

#ifdef __cplusplus
}
#endif


/* fin de fichier */

