/**
 * JASMINe VMMapi: JASMINe Virtual Machine Management API
 * Copyright (C) 2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: VMMException.java 3174 2009-03-19 13:31:24Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.vmm.api;

/**
 * The base exception to be thrown by a VMM agent
 */
public class VMMException extends Exception {
    private static final long serialVersionUID = 8718901373581715062L;

    /**
     * Constructs a new exception with null as its detail message.
     */
    public VMMException() {
        super();
    }

    /**
     * Constructs a new exception with the specified detail message.
     *
     * @param message detail message
     */
    public VMMException(final String message) {
        super(message);
    }

    /**
     * Constructs a new exception with the specified detail message and cause.
     *
     * @param message the detail message
     * @param cause the cause
     */
    public VMMException(final String message, final Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructs a new exception with the specified cause and a detail message
     * of (cause==null ? null : cause.toString())
     *
     * @param cause the cause
     */
    public VMMException(final Throwable cause) {
        super(cause.getMessage(), cause);
    }
}
