/**
 * JASMINe VMMapi: JASMINe Virtual Machine Management API
 * Copyright (C) 2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: VMConfigSpec.java 3210 2009-03-31 11:37:38Z chahinem $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.vmm.api;

import java.io.Serializable;

/**
 * The <tt>VMConfigSpec</tt> class is a helper class used to describe the
 * configuration of a virtual machine to be created
 */
public class VMConfigSpec implements Serializable {

    /**
     * Auto-generated serial version ID.
     */
    private static final long serialVersionUID = -5174963382169498530L;

    /**
     * Constructs a <tt>VMConfigSpec</tt> object
     * 
     * @param name the name of the virtual machine
     * @param memorySizeMB the initial memory allocation in MBytes
     * @param numVCPU the number of virtual CPUs
     * @param diskSizeMB the disk size in MBytes
     * @param vmImageUUID the uuid of the VM image that will be used to create
     *        the VM
     */
    public VMConfigSpec(final String name, final long memorySizeMB, final int numVCPU, final int diskSizeMB,
        final String vmImageUUID) {
        this.name = name;
        this.memorySizeMB = memorySizeMB;
        this.numVCPU = numVCPU;
        this.diskSizeMB = diskSizeMB;
        this.vmImageUUID = vmImageUUID;
    }

    /**
     * Constructs a <tt>VMConfigSpec</tt> object as a copy of the argument
     * 
     * @param other original object to copy
     */
    public VMConfigSpec(final VMConfigSpec other) {
        this.name = new String(other.name);
        this.memorySizeMB = other.memorySizeMB;
        this.numVCPU = other.numVCPU;
        this.diskSizeMB = other.diskSizeMB;
        this.vmImageUUID = new String(other.vmImageUUID);
    }

    /**
     * Constructs a <tt>VMConfigSpec</tt> object
     */
    public VMConfigSpec() {
    }

    private String name;

    private long memorySizeMB;

    private int numVCPU;

    private int diskSizeMB;

    private String vmImageUUID;

    /**
     * Sets the name of the virtual machine
     * 
     * @param name
     */
    public void setName(final String name) {
        this.name = name;
    }

    /**
     * Sets the memory size of the virtual machine configuration in MBytes
     * 
     * @param memorySizeMB
     */
    public void setMemorySizeMB(final long memorySizeMB) {
        this.memorySizeMB = memorySizeMB;
    }

    /**
     * Sets the number of virtual CPUs
     * 
     * @param numVCPU
     */
    public void setNumVCPU(final int numVCPU) {
        this.numVCPU = numVCPU;
    }

    /**
     * Sets the disk size in MBytes
     * 
     * @param diskSizeMB
     */
    public void setDiskSizeMB(final int diskSizeMB) {
        this.diskSizeMB = diskSizeMB;
    }

    /**
     * Sets the image ID of the virtual machine
     * 
     * @param diskImageID
     */
    public void setVmImageUUID(final String diskImageID) {
        this.vmImageUUID = diskImageID;
    }

    /**
     * Returns the name of virtual machine
     * 
     * @return name of the virtual machine
     */
    public String getName() {
        return this.name;
    }

    /**
     * Returns the memory size of the virtual machine in MBytes
     * 
     * @return
     */
    public long getMemorySizeMB() {
        return this.memorySizeMB;
    }

    /**
     * Returns the number of virtual CPUs of the virtual machine configuration
     * 
     * @return
     */
    public int getNumVCPU() {
        return this.numVCPU;
    }

    /**
     * Returns the disk size in MBytes of the virtual machine configuration
     * 
     * @return
     */
    public int getDiskSizeMB() {
        return this.diskSizeMB;
    }

    /**
     * Returns the image ID of the virtual machine configuration
     * 
     * @return
     */
    public String getVmImageUUID() {
        return this.vmImageUUID;
    }
}
