/**
 * JASMINe VMMapi: JASMINe Virtual Machine Management API
 * Copyright (C) 2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: BadVMPowerStateException.java 3171 2009-03-19 13:29:01Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.vmm.api;

/**
 * Thrown when an operation is attempted on a VM that is not in the appropriate
 * state
 */
public class BadVMPowerStateException extends VMMException {
    private static final long serialVersionUID = -4304319824807061861L;

    /**
     * Constructs a new exception with the specified detail message.
     *
     * @param message detail message
     */
    public BadVMPowerStateException(final String message) {
        super(message);
    }

    /**
     * Constructs a new exception with the specified detail message and cause.
     *
     * @param message the detail message
     * @param cause the cause
     */
    public BadVMPowerStateException(final String message, final Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructs a new exception with the specified cause and a detail message
     * of (cause==null ? null : cause.toString())
     *
     * @param cause the cause
     */
    public BadVMPowerStateException(final Throwable cause) {
        super(cause);
    }

}
