/**
 * JASMINe VMMapi: JASMINe Virtual Machine Management API
 * Copyright (C) 2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: VirtualMachineImageStoreMXBean.java 3171 2009-03-19 13:29:01Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.vmm.api;

import java.util.List;

/**
 * Management interface of a VirtualMachineImageStore. A
 * VirtualMachineImageStore is a storage repository for virtual machine images.
 * that can be used as templates when creating a new virtual machine.
 * <p>
 * A VirtualMachineImageStore either belongs to a server pool or to host. In the
 * former case, the VirtualMachineImageStore is shared among all hosts belonging
 * to the pool. In the latter case, the VirtualMachineImageStore refers to the
 * local disk of the host.
 * <p>
 * <p>
 * The <tt>ObjectName</tt> for identifying a VirtualMachineImageStoreMXBean
 * follows the following template: <blockquote>
 * org.ow2.jasmine.vmm.api:type=VirtualMachineImageStore,name=&lt;pathname&gt;
 * </blockquote>
 * <p>
 */
public interface VirtualMachineImageStoreMXBean extends ManagedResourceMXBean {

    /**
     * Returns the virtual image (if any) whose UUID is provided as argument
     *
     * @param uuid the UUID of the virtual image to look up
     * @return the virtual image matching the provided UUID or null if none is
     *         found
     */
    VirtualMachineImageMXBean lookUpByUUID(String uuid);

    /**
     * Lists the VM images available on this VirtualMachineImageStore
     *
     * @return list of VM image ID
     */
    List<VirtualMachineImageMXBean> listVMImageTemplates();

    /**
     * Removes a VM image from the VirtualMachineImageStore
     *
     * @param vmImageID the ID of the VM image to remove
     * @throws VMMException raised if the operation fails
     */
    void removeVMImageTemplate(VirtualMachineImageMXBean image) throws VMMException;

    /**
     * Returns the name of the VirtualMachineImageStore
     *
     * @return
     */
    String getName();

    /**
     * Returns the storage capacity of the VirtualMachineImageStore in MBytes
     *
     * @return
     */
    long getCapacityMB();

    /**
     * Returns the free storage capacity of the VirtualMachineImageStore in
     * MBytes
     *
     * @return
     */
    long getFreeSpaceMB();
}
