package org.ow2.jasmine.vmm.api;

/**
 * This class defines the IP settings of a virtual NIC attached to a VM
 */
public class VnicIPSettings {
    public enum IpAssignmentMode {
        FIXED, DHCP, NONE
    }

    private String ipAddress;

    private String subnetMask;

    private String gateway;

    private IpAssignmentMode ipAssignmentMode;

    /**
     * Constructs an instance of VnicIPSettings
     */
    public VnicIPSettings() {
    }

    /**
     * Constructs an instance initialized with the settings of another
     * VnicIPSettings instance
     * 
     * @param other the instance whose settings are copied into the new instance
     */
    public VnicIPSettings(final VnicIPSettings other) {
        if (other != null) {
            this.subnetMask = other.subnetMask;
            this.gateway = other.gateway;
            this.ipAddress = other.ipAddress;
            this.ipAssignmentMode = other.ipAssignmentMode;
        }
    }

    /**
     * Returns the subnet mask
     * 
     * @return the subnet mask
     */
    public String getSubnetMask() {
        return this.subnetMask;
    }

    /**
     * Sets the subnet mask
     * 
     * @param subnetMask the given subnet mask
     */
    public void setSubnetMask(final String subnetMask) {
        this.subnetMask = subnetMask;
    }

    /**
     * Returns the gateway
     * 
     * @return the gateway of the NIC associated with these settings
     */
    public String getGateway() {
        return this.gateway;
    }

    /**
     * Sets the gateway
     * 
     * @param gateway the given gateway
     */
    public void setGateway(final String gateway) {
        this.gateway = gateway;
    }

    /**
     * Returns the IP address
     * 
     * @return the IP address of the NIC associated with these settings
     */
    public String getIpAddress() {
        return this.ipAddress;
    }

    /**
     * Sets the IP address of the NIC associated with this instance
     * 
     * @param ipAddress the given IP address
     */
    public void setIpAddress(final String ipAddress) {
        this.ipAddress = ipAddress;
    }

    /**
     * Returns the IP assignement mode of the NIC associated with this instance
     * 
     * @return the IP assignment mode
     */
    public IpAssignmentMode getIpAssignmentMode() {
        return this.ipAssignmentMode;
    }

    /**
     * Sets the the IP assignment mode of the NIC associated with this instance
     * 
     * @param ipAssignmentMode the given IP assignment mode
     */
    public void setIpAssignmentMode(final IpAssignmentMode ipAssignmentMode) {
        this.ipAssignmentMode = ipAssignmentMode;
    }

    /*
     * (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String s = "GuestIPSetting[";
        s += this.ipAssignmentMode + ":";
        if (this.ipAssignmentMode == IpAssignmentMode.FIXED) {
            s += "ip=" + this.ipAddress + ",mask=" + this.subnetMask + ",gateway=" + this.gateway;
        }
        s += "]";
        return s;
    }

}
