/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.management.openmbean.CompositeData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUsage
implements Serializable {
    private static final long serialVersionUID = -4750072156087484043L;
    private Date samplingTime;
    private float cpuLoad;
    private long memoryUsedKBytes;
    private List<NetworkStats> networkStats;
    private List<DiskStats> diskStats;

    public static ResourceUsage from(CompositeData cd) {
        ResourceUsage ru = new ResourceUsage();
        ru.setSamplingTime((Date)cd.get("samplingTime"));
        ru.setCpuLoad(((Float)cd.get("cpuLoad")).floatValue());
        ru.setMemoryUsedKBytes((Long)cd.get("memoryUsedKBytes"));
        CompositeData[] cds = (CompositeData[])cd.get("networkStats");
        ArrayList<NetworkStats> netStats = new ArrayList<NetworkStats>();
        for (CompositeData ncd : cds) {
            NetworkStats entry = new NetworkStats();
            entry.setDeviceName((String)ncd.get("deviceName"));
            entry.setNetReceivedKbitPerSec((Long)ncd.get("netReceivedKbitPerSec"));
            entry.setNetTransmittedKbitPerSec((Long)ncd.get("netTransmittedKbitPerSec"));
            netStats.add(entry);
        }
        ru.setNetworkStats(netStats);
        cds = (CompositeData[])cd.get("diskStats");
        ArrayList<DiskStats> diskStats = new ArrayList<DiskStats>();
        for (CompositeData ncd : cds) {
            DiskStats entry = new DiskStats();
            entry.setDeviceName((String)ncd.get("deviceName"));
            entry.setDiskReadKBytePerSec((Long)ncd.get("diskReadKBytePerSec"));
            entry.setDiskWrittenKBytesPerSec((Long)ncd.get("diskWrittenKBytesPerSec"));
            diskStats.add(entry);
        }
        ru.setDiskStats(diskStats);
        return ru;
    }

    public Date getSamplingTime() {
        return this.samplingTime;
    }

    public float getCpuLoad() {
        return this.cpuLoad;
    }

    public long getMemoryUsedKBytes() {
        return this.memoryUsedKBytes;
    }

    public List<NetworkStats> getNetworkStats() {
        return this.networkStats;
    }

    public List<DiskStats> getDiskStats() {
        return this.diskStats;
    }

    public void setSamplingTime(Date samplingTime) {
        this.samplingTime = samplingTime;
    }

    public void setCpuLoad(float cpuLoad) {
        this.cpuLoad = cpuLoad;
    }

    public void setMemoryUsedKBytes(long memoryUsedKBytes) {
        this.memoryUsedKBytes = memoryUsedKBytes;
    }

    public void setNetworkStats(List<NetworkStats> networkStats) {
        this.networkStats = networkStats;
    }

    public void setDiskStats(List<DiskStats> diskStats) {
        this.diskStats = diskStats;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("(time=" + this.samplingTime + "),(cpu=" + this.cpuLoad + "%),(memory=" + this.memoryUsedKBytes + " Kbytes),");
        for (DiskStats ds : this.diskStats) {
            sb.append(ds);
            sb.append(",");
        }
        for (NetworkStats ns : this.networkStats) {
            sb.append(ns);
            sb.append(",");
        }
        return sb.toString();
    }

    public static class NetworkStats
    implements Serializable {
        private static final long serialVersionUID = -815338799963686071L;
        private String deviceName;
        private long netReceivedKbitPerSec;
        private long netTransmittedKbitPerSec;

        public NetworkStats() {
        }

        public NetworkStats(String deviceName, long netReceivedKbitPerSec, long netTransmittedKbitPerSec) {
            this.deviceName = deviceName;
            this.netReceivedKbitPerSec = netReceivedKbitPerSec;
            this.netTransmittedKbitPerSec = netTransmittedKbitPerSec;
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public long getNetReceivedKbitPerSec() {
            return this.netReceivedKbitPerSec;
        }

        public long getNetTransmittedKbitPerSec() {
            return this.netTransmittedKbitPerSec;
        }

        public void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public void setNetReceivedKbitPerSec(long netReceivedKbitPerSec) {
            this.netReceivedKbitPerSec = netReceivedKbitPerSec;
        }

        public void setNetTransmittedKbitPerSec(long netTransmittedKbitPerSec) {
            this.netTransmittedKbitPerSec = netTransmittedKbitPerSec;
        }

        public String toString() {
            return "(net=" + this.deviceName + ",rcv=" + this.netReceivedKbitPerSec + " Kb/s,tx=" + this.netTransmittedKbitPerSec + " Kb/s)";
        }
    }

    public static class DiskStats
    implements Serializable {
        private static final long serialVersionUID = -3692224237657640220L;
        private String deviceName;
        private long diskReadKBytePerSec;
        private long diskWrittenKBytesPerSec;

        public DiskStats() {
        }

        public DiskStats(String deviceName, long diskReadKBytePerSec, long diskWrittenKBytesPerSec) {
            this.deviceName = deviceName;
            this.diskReadKBytePerSec = diskReadKBytePerSec;
            this.diskWrittenKBytesPerSec = diskWrittenKBytesPerSec;
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public long getDiskReadKBytePerSec() {
            return this.diskReadKBytePerSec;
        }

        public long getDiskWrittenKBytesPerSec() {
            return this.diskWrittenKBytesPerSec;
        }

        public void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public void setDiskReadKBytePerSec(long diskReadKBytePerSec) {
            this.diskReadKBytePerSec = diskReadKBytePerSec;
        }

        public void setDiskWrittenKBytesPerSec(long diskWrittenKBytesPerSec) {
            this.diskWrittenKBytesPerSec = diskWrittenKBytesPerSec;
        }

        public String toString() {
            return "(disk=" + this.deviceName + ",read=" + this.diskReadKBytePerSec + " KB/s,written=" + this.diskWrittenKBytesPerSec + " KB/s)";
        }
    }
}

