/**
 * JASMINe VMMapi: JASMINe Virtual Machine Management API
 * Copyright (C) 2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: InvalidVMConfigException.java 6064 2010-02-18 14:05:50Z jlegrand $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.vmm.api;

/**
 * Thrown if the a VM configuration is invalid
 */
public class InvalidVMConfigException extends VMMException {
    private static final long serialVersionUID = 7520334798463689289L;

    /**
     * Constructs a new exception with null as its detail message.
     */
    public InvalidVMConfigException() {
    }

    /**
     * Constructs a new exception with the specified detail message.
     *
     * @param message detail message
     */
    public InvalidVMConfigException(final String message) {
        super(message);
    }

    /**
     * Constructs a new exception with the specified cause and a detail message
     * of (cause==null ? null : cause.toString())
     *
     * @param cause the cause
     */
    public InvalidVMConfigException(final String message, final Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructs a new exception with the specified cause and a detail message
     * of (cause==null ? null : cause.toString())
     *
     * @param cause the cause
     */
    public InvalidVMConfigException(final Throwable cause) {
        super(cause);
    }

}
