/**
 * JASMINe VMMapi: JASMINe Virtual Machine Management API
 * Copyright (C) 2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: NotificationTypes.java 6095 2010-02-23 13:22:40Z dangtran $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.vmm.api;

/**
 * Notification types that can be emitted by VMM MXBeans
 */
public interface NotificationTypes {
    /**
     * Emitted by a HostMXBean when a new VM is created The user data of the
     * notification is the object name of the newly created virtual machine
     */
    public static String VM_ADD = "vm.add";

    /**
     * Emitted by a HostMXBean when a VM has been destroyed The user data of the
     * notification is the object name of the destroyed virtual machine.
     */
    public static String VM_DEL = "vm.del";

    /**
     * Emitted by a VirtualMachineMXBean when the state of the VM changes The
     * notification message has one of the following values:
     * <ul>
     * <li>RUNNING
     * <li>HALTED
     * <li>SUSPENDED
     * <li>PAUSED
     * <li>UNKNOWN
     * </ul>
     */
    public static String VM_STATE_CHANGE = "vm.state";

    /**
     * Emitted by a a VirtualMachineMXBean after a successful migration The
     * notification message is set to the host name of the new host of the
     * virtual machine.
     */
    public static String VM_MIGRATION = "vm.migration";

    /**
     * Emitted by a a VirtualMachineMXBean when a migration is started The
     * notification message is set to the host name of the target host to where
     * the virtual machine is migrating
     */
    public static String VM_MIGRATION_START = "vm.migration.start";

    /**
     * Emitted by a a VirtualMachineMXBean when a migration has failed The
     * notification message is set to the host name of the target host of the
     * migration
     */
    public static String VM_MIGRATION_ABORT = "vm.migration.abort";

    /**
     * Emitted by a HostMXBean to report performance metrics
     */
    public static String PERF_REPORT = "host.perfreport";

    /**
     * Emitted by a HostMXBean when the state of the driver-specific connection
     * to the hypervisor changes
     */
    public static String HYPERVISOR_CONNECTION_STATE = "driver.connection.state";

    /**
     * Emitted when an error occurs during an asynchronous operation
     */
    public static String ERROR = "vm.error";

    /**
     * For debugging purposes only
     */
    public static String LOG = "log";
}
