/**
 * JASMINe VMMapi: JASMINe Virtual Machine Management API
 * Copyright (C) 2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: VirtualMachineImageMXBean.java 6096 2010-02-23 13:24:51Z dangtran $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.vmm.api;

import java.util.Map;

/**
 * Management interface of a VirtualMachineImage.
 * <p>
 * <p>
 * The <tt>ObjectName</tt> for identifying a VirtualMachineImageMXBean follows
 * the following template: <blockquote>
 * org.ow2.jasmine.vmm.api:type=VirtualMachineImage
 * ,name=&lt;pathname&gt;,uuid=&lt;uuid&gt; </blockquote>
 * <p>
 */
public interface VirtualMachineImageMXBean extends ManagedResourceMXBean {
    /**
     * Returns the UUID of the virtual image
     * 
     * @return the UUID of the virtual image
     */
    public String getUUID();

    /**
     * Returns the user-friendly name of the virtual image
     * 
     * @return
     */
    public String getName();

    /**
     * Returns the metadata of the virtual image
     * 
     * @return the metadata of the virtual image
     */
    public Map<String, String> getMetaData();

    /**
     * Returns a description of the virtual image
     * 
     * @return a description of the virtual image
     */
    public String getDescription();
}
