/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.jasmine.vmm.api.VnicIPSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VMCustomizationSpec
implements Serializable {
    private static final long serialVersionUID = -8000190535943480037L;
    private String guestOsDomain;
    private String guestOsHostName;
    private List<String> guestOsDnsServerList;
    private List<VnicIPSettings> vnicIpSettingsList;
    private Map<String, String> guestOsCustomizationParams;

    public VMCustomizationSpec(VMCustomizationSpec other) {
        this.guestOsDomain = other.guestOsDomain;
        this.guestOsHostName = other.guestOsHostName;
        this.guestOsDnsServerList = other.guestOsDnsServerList != null ? new ArrayList<String>(other.guestOsDnsServerList) : null;
        this.vnicIpSettingsList = other.vnicIpSettingsList != null ? new ArrayList<VnicIPSettings>(other.vnicIpSettingsList) : null;
        this.guestOsCustomizationParams = other.guestOsCustomizationParams != null ? new HashMap<String, String>(other.guestOsCustomizationParams) : null;
    }

    public VMCustomizationSpec() {
        this.guestOsDnsServerList = new ArrayList<String>();
        this.vnicIpSettingsList = new ArrayList<VnicIPSettings>();
        this.guestOsCustomizationParams = new HashMap<String, String>();
    }

    public void setGuestOsDomain(String domain) {
        this.guestOsDomain = domain;
    }

    public String getGuestOsDomain() {
        return this.guestOsDomain;
    }

    public String getGuestOsHostName() {
        return this.guestOsHostName;
    }

    public void setGuestOsHostName(String hostName) {
        this.guestOsHostName = hostName;
    }

    public List<String> getGuestOsDnsServerList() {
        return new ArrayList<String>(this.guestOsDnsServerList);
    }

    public void setGuestOsDnsServerList(List<String> dnsServerList) {
        this.guestOsDnsServerList = new ArrayList<String>(dnsServerList);
    }

    public void addVnicIpSettings(VnicIPSettings ipSettings) {
        this.vnicIpSettingsList.add(ipSettings);
    }

    public void setVnicIpSettingsList(List<VnicIPSettings> ipSettingsList) {
        this.vnicIpSettingsList = ipSettingsList;
    }

    public List<VnicIPSettings> getVnicIpSettingsList() {
        return new ArrayList<VnicIPSettings>(this.vnicIpSettingsList);
    }

    public Map<String, String> getGuestOsCustomizationParams() {
        return this.guestOsCustomizationParams;
    }

    public void setGuestOsCustomizationParams(Map<String, String> guestCustomizationParams) {
        this.guestOsCustomizationParams = guestCustomizationParams;
    }

    public void addGuestOsCustomizationParam(String paramName, String paramValue) {
        this.guestOsCustomizationParams.put(paramName, paramValue);
    }
}

