/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.api;

import java.util.Date;
import java.util.Map;
import org.ow2.jasmine.vmm.api.BadVMPowerStateException;
import org.ow2.jasmine.vmm.api.HostMXBean;
import org.ow2.jasmine.vmm.api.IllegalOperationException;
import org.ow2.jasmine.vmm.api.InsufficientResourcesException;
import org.ow2.jasmine.vmm.api.ManagedResourceMXBean;
import org.ow2.jasmine.vmm.api.ResourceUsage;
import org.ow2.jasmine.vmm.api.VMCustomizationSpec;
import org.ow2.jasmine.vmm.api.VMMException;
import org.ow2.jasmine.vmm.api.VirtualMachineImageMXBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface VirtualMachineMXBean
extends ManagedResourceMXBean {
    public String getUuid() throws VMMException;

    public HostMXBean getHostMBean() throws VMMException;

    public String getNameLabel() throws VMMException;

    public String getMacAddress() throws VMMException;

    public String getGuestIpAddress() throws VMMException;

    public float[] getLoadPerVCPU() throws VMMException;

    public float getCPULoad() throws VMMException;

    public Date getStartTime() throws VMMException;

    public long getMemorySizeMB() throws VMMException;

    public void setMemorySizeMB(long var1) throws VMMException;

    public long getMemoryUsedMB() throws VMMException;

    public ResourceUsage getResourceUsage() throws VMMException;

    public int getNumVCPUs() throws VMMException;

    public void setNumVCPUs(int var1) throws VMMException;

    public int getSchedulingCap() throws VMMException;

    public void setSchedulingCap(int var1) throws VMMException;

    public int getSchedulingWeight() throws VMMException;

    public void setSchedulingWeight(int var1) throws VMMException;

    public boolean[][] getCPUAffinity() throws VMMException;

    public void setCPUAffinity(boolean[][] var1) throws VMMException;

    public PowerState getState() throws VMMException;

    public void suspend() throws VMMException, BadVMPowerStateException;

    public void resume() throws VMMException, BadVMPowerStateException;

    public void shutdown() throws VMMException, BadVMPowerStateException;

    public void start() throws VMMException, BadVMPowerStateException;

    public void pause() throws VMMException, BadVMPowerStateException;

    public void unpause() throws VMMException, BadVMPowerStateException;

    public void reboot() throws VMMException, BadVMPowerStateException;

    public void destroy() throws VMMException;

    public boolean canLiveMigrateToHost(HostMXBean var1) throws VMMException;

    public void migrate(HostMXBean var1, boolean var2) throws IllegalOperationException, VMMException;

    public String getUserData(String var1) throws VMMException;

    public String getConsole() throws VMMException;

    public VirtualMachineMXBean cloneVM(String var1, VMCustomizationSpec var2, boolean var3) throws InsufficientResourcesException, VMMException;

    public VirtualMachineImageMXBean makeTemplate(String var1, String var2, Map<String, String> var3) throws InsufficientResourcesException, IllegalOperationException, BadVMPowerStateException, VMMException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PowerState {
        HALTED,
        PAUSED,
        RUNNING,
        SUSPENDED,
        UNKNOWN;

    }
}

