/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.antmodular.jonasbase.web.jetty;

import org.apache.tools.ant.Task;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.JReplace;
import org.ow2.jonas.antmodular.jonasbase.web.jetty.JettyHttps;
import org.ow2.jonas.antmodular.web.base.Ajp;
import org.ow2.jonas.antmodular.web.base.Connector;

public abstract class JettyConnector
extends Connector {
    public void addConfiguredHttps(JettyHttps jettyHttps, String confFile) {
        JReplace propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile(confFile);
        propertyReplace.setToken("<!-- Add a HTTPS SSL listener on port 9043");
        StringBuffer value = new StringBuffer();
        value.append("<!-- Add a HTTPS SSL listener on port " + jettyHttps.getPort() + "                           -->\n");
        value.append("  <!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->\n");
        value.append("  <Call name=\"addListener\">\n");
        value.append("    <Arg>\n");
        if ("ibm".equalsIgnoreCase(jettyHttps.getVm())) {
            value.append("      <New class=\"org.mortbay.http.IbmJsseListener\">\n");
        } else {
            value.append("      <New class=\"org.mortbay.http.SunJsseListener\">\n");
        }
        value.append("        <Set name=\"Port\">" + jettyHttps.getPort() + "</Set>\n");
        value.append("        <Set name=\"MinThreads\">5</Set>\n");
        value.append("        <Set name=\"MaxThreads\">100</Set>\n");
        value.append("        <Set name=\"MaxIdleTimeMs\">30000</Set>\n");
        value.append("        <Set name=\"LowResourcePersistTimeMs\">2000</Set>\n");
        if (jettyHttps.getKeystoreFile() != null) {
            value.append("        <Set name=\"Keystore\">" + jettyHttps.getKeystoreFile() + "</Set>\n");
        }
        if (jettyHttps.getKeystorePass() != null) {
            value.append("        <Set name=\"Password\">" + jettyHttps.getKeystorePass() + "</Set>\n");
        }
        if (jettyHttps.getKeyPassword() != null) {
            value.append("  <Set name=\"KeyPassword\">" + jettyHttps.getKeyPassword() + "</Set>\n");
        }
        value.append("      </New>\n");
        value.append("    </Arg>\n");
        value.append("  </Call>\n\n");
        value.append("  <!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->\n");
        value.append("  <!-- Add a HTTPS SSL listener on port 9043");
        propertyReplace.setValue(value.toString());
        propertyReplace.setLogInfo("[Jetty] Setting HTTPS port number to : " + jettyHttps.getPort());
        this.addTask((Task)propertyReplace);
        propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile(confFile);
        propertyReplace.setToken("9043");
        propertyReplace.setValue(jettyHttps.getPort());
        propertyReplace.setLogInfo("[Jetty] Fix HTTP redirect port number to : " + jettyHttps.getPort());
        this.addTask((Task)propertyReplace);
    }

    public void addConfiguredAjp(Ajp ajp, String confFile) {
        JReplace propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile(confFile);
        propertyReplace.setToken("<!-- Add a AJP13 listener on port 8009");
        StringBuffer value = new StringBuffer();
        value.append("<!-- Add a AJP13 listener on port " + ajp.getPort() + "                               -->\n");
        value.append("  <!-- This protocol can be used with mod_jk in apache, IIS etc.       -->\n");
        value.append("  <!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->\n");
        value.append("  <Call name=\"addListener\">\n");
        value.append("    <Arg>\n");
        value.append("      <New class=\"org.mortbay.http.ajp.AJP13Listener\">\n");
        value.append("        <Set name=\"Port\">" + ajp.getPort() + "</Set>\n");
        value.append("        <Set name=\"MinThreads\">5</Set>\n");
        value.append("        <Set name=\"MaxThreads\">20</Set>\n");
        value.append("        <Set name=\"MaxIdleTimeMs\">0</Set>\n");
        value.append("        <Set name=\"confidentialPort\">9043</Set>\n");
        value.append("      </New>\n");
        value.append("    </Arg>\n");
        value.append("  </Call>\n\n");
        value.append("  <!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->\n");
        value.append("  <!-- Add a AJP13 listener on port 8009");
        propertyReplace.setValue(value.toString());
        propertyReplace.setLogInfo("[Jetty] Setting AJP Connector to : " + ajp.getPort());
        this.addTask((Task)propertyReplace);
    }

    public abstract void addConfiguredHttps(JettyHttps var1);

    public abstract void addConfiguredAjp(Ajp var1);
}

