/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.antmodular.jonasbase.bootstrap;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.ow2.jonas.antmodular.bootstrap.JOnASAntTool;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.AbstractJOnASBaseAntTask;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.JMkdir;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.Services;

public class JOnASBaseTask
extends AbstractJOnASBaseAntTask {
    public static final String JONAS_CONF_FILE = "jonas.properties";
    public static final String DOMAIN_CONF_FILE = "domain.xml";
    public static final String LOG_DIR_NAME = "logs";
    public static final String DEPLOY_DIR_NAME = "deploy";
    public static final String LIB_EXT_DIR_NAME = "lib/ext";
    protected boolean onlyUpdate = false;

    public void execute() {
        super.execute();
        File jprops = new File(this.destDir.getPath() + File.separator + "conf" + File.separator + JONAS_CONF_FILE);
        if (this.onlyUpdate && !jprops.exists()) {
            throw new BuildException("JOnAS base directory '" + this.destDir.getPath() + "' doesn't exists. Cannot update.");
        }
        if (!this.onlyUpdate) {
            this.log("Creating JONAS_BASE in the directory '" + this.destDir + "' from source directory '" + this.jonasRoot + "'", 2);
            Copy copy = new Copy();
            JOnASAntTool.configure(this, (Task)copy);
            copy.setTodir(this.destDir);
            FileSet confFileSet = new FileSet();
            confFileSet.setDir(new File(new File(this.jonasRoot, "templates"), "conf"));
            copy.addFileset(confFileSet);
            File deployablesTemplateDirectory = new File(new File(this.jonasRoot, "templates"), DEPLOY_DIR_NAME);
            if (deployablesTemplateDirectory.exists()) {
                FileSet deployFileSet = new FileSet();
                deployFileSet.setDir(deployablesTemplateDirectory);
                copy.addFileset(deployFileSet);
            }
            copy.setOverwrite(true);
            copy.execute();
            this.log("Creating logs in the directory '" + this.destDir, 2);
            JMkdir mkdir = new JMkdir();
            JOnASAntTool.configure(this, (Task)mkdir);
            mkdir.setDestDir(new File(this.destDir + File.separator + LOG_DIR_NAME));
            mkdir.execute();
            this.log("Creating lib/ext in the directory '" + this.destDir, 2);
            mkdir = new JMkdir();
            JOnASAntTool.configure(this, (Task)mkdir);
            mkdir.setDestDir(new File(this.destDir + File.separator + LIB_EXT_DIR_NAME));
            mkdir.execute();
        } else {
            this.log("Only updating JONAS_BASE in the directory '" + this.destDir + "' from source directory '" + this.jonasRoot + "'", 2);
        }
        super.executeAllTask();
        JOnASAntTool.updateJonasBase(this, this.jonasRoot, this.destDir, null);
    }

    public void addConfiguredServices(Services servicesTasks) {
        this.addTask(servicesTasks);
    }

    public void setUpdate(boolean onlyUpdate) {
        this.onlyUpdate = onlyUpdate;
    }
}

