/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.antmodular.jonasbase.web.tomcat7;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.JReplace;
import org.ow2.jonas.antmodular.jonasbase.web.tomcat.TomcatAjp;
import org.ow2.jonas.antmodular.jonasbase.web.tomcat.TomcatConnectors;
import org.ow2.jonas.antmodular.jonasbase.web.tomcat.TomcatHttp;
import org.ow2.jonas.antmodular.jonasbase.web.tomcat.TomcatHttps;
import org.ow2.jonas.antmodular.web.base.Director;

public class Tomcat7Connectors
extends TomcatConnectors {
    public static final String TOMCAT_7_HTPP_CONNECTOR = "tomcat7-http-connector.xml";
    public static final String TOMCAT_7_HTTPS_CONNECTOR = "tomcat7-https-connector.xml";
    public static final String TOMCAT_7_AJP_CONNECTOR = "tomcat7-ajp-connector.xml";
    public static final String EOL = "\n";
    public String httpRedirectPort;

    public void addConfiguredHttp(TomcatHttp tomcatHttp) {
        String maxKeepAliveRequests;
        String compression;
        String acceptCount;
        String connectionTimeout;
        String enableLookups;
        String minSpareThreads;
        this.httpConfigured = true;
        JReplace propertyReplace = new JReplace();
        propertyReplace.setDeployableFile(TOMCAT_7_HTPP_CONNECTOR);
        propertyReplace.setToken("<property name=\"port\">9000</property>");
        StringBuilder value = new StringBuilder();
        value.append("<property name=\"port\">" + tomcatHttp.getPort() + "</property>");
        String maxThreads = tomcatHttp.getMaxThreads();
        if (maxThreads != null) {
            value.append("\n    <property name=\"maxThreads\">" + maxThreads + "</property>");
        }
        if ((minSpareThreads = tomcatHttp.getMinSpareThreads()) != null) {
            value.append("\n    <property name=\"minSpareThreads\">" + minSpareThreads + "</property>");
        }
        if ((enableLookups = tomcatHttp.getEnableLookups()) != null) {
            value.append("\n    <property name=\"enableLookups\">" + tomcatHttp.getEnableLookups() + "</property>");
        }
        if ((connectionTimeout = tomcatHttp.getConnectionTimeout()) != null) {
            value.append("\n    <property name=\"connectionTimeout\">" + connectionTimeout + "</property>");
        }
        if ((acceptCount = tomcatHttp.getAcceptCount()) != null) {
            value.append("\n    <property name=\"acceptCount\">" + acceptCount + "</property>");
        }
        if ((compression = tomcatHttp.getCompression()) != null) {
            value.append("\n    <property name=\"compression\">" + compression + "</property>");
        }
        if ((maxKeepAliveRequests = tomcatHttp.getMaxKeepAliveRequest()) != null) {
            value.append("\n    <property name=\"maxKeepAliveRequests\">" + maxKeepAliveRequests + "</property>");
        }
        propertyReplace.setValue(value.toString());
        this.addTask(propertyReplace);
        String redirectPort = tomcatHttp.getRedirectPort();
        if (redirectPort != null) {
            JReplace redirectPortReplace = new JReplace();
            redirectPortReplace.setDeployableFile(TOMCAT_7_HTPP_CONNECTOR);
            if (this.httpRedirectPort != null) {
                redirectPortReplace.setToken("<property name=\"redirectPort\">" + this.httpRedirectPort + "</property>");
            } else {
                redirectPortReplace.setToken("<property name=\"redirectPort\">" + TomcatHttp.DEFAULT_REDIRECT_PORT + "</property>");
            }
            redirectPortReplace.setValue("<property name=\"redirectPort\">" + redirectPort + "</property>");
            this.addTask(redirectPortReplace);
            this.httpRedirectPort = redirectPort;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfiguredHttps(TomcatHttps tomcatHttps) {
        super.addConfiguredHttps(tomcatHttps, "tomcat7-server.xml");
        File httpsConnectorFile = new File(this.getJOnASBase(), "deploy" + File.separator + TOMCAT_7_HTTPS_CONNECTOR);
        FileOutputStream fileOutputStream = null;
        try {
            String keystorePass;
            String keystore;
            String maxKeepAliveRequests;
            String compression;
            String acceptCount;
            String connectionTimeout;
            String enableLookups;
            String minSpareThreads;
            String maxThreads;
            try {
                fileOutputStream = new FileOutputStream(httpsConnectorFile);
            }
            catch (FileNotFoundException e) {
                this.log("Cannot create file " + httpsConnectorFile.getAbsolutePath() + ": " + e, 0);
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            stringBuilder.append("\n<configadmin xmlns=\"http://jonas.ow2.org/ns/configadmin/1.0\">");
            stringBuilder.append("\n  <factory-configuration pid=\"Tomcat7HttpsConnector\">");
            stringBuilder.append("\n    <property name=\"address\">localhost</property>");
            stringBuilder.append("\n    <property name=\"port\">" + tomcatHttps.getPort() + "</property>");
            String redirectPort = tomcatHttps.getRedirectPort();
            if (redirectPort != null) {
                stringBuilder.append("\n    <property name=\"redirectPort\">" + redirectPort + "</property>");
            }
            if ((maxThreads = tomcatHttps.getMaxThreads()) != null) {
                stringBuilder.append("\n    <property name=\"maxThreads\">" + maxThreads + "</property>");
            }
            if ((minSpareThreads = tomcatHttps.getMinSpareThreads()) != null) {
                stringBuilder.append("\n    <property name=\"minSpareThreads\">" + minSpareThreads + "</property>");
            }
            if ((enableLookups = tomcatHttps.getEnableLookups()) != null) {
                stringBuilder.append("\n    <property name=\"enableLookups\">" + enableLookups + "</property>");
            }
            if ((connectionTimeout = tomcatHttps.getConnectionTimeout()) != null) {
                stringBuilder.append("\n    <property name=\"connectionTimeout\">" + connectionTimeout + "</property>");
            }
            if ((acceptCount = tomcatHttps.getAcceptCount()) != null) {
                stringBuilder.append("\n    <property name=\"acceptCount\">" + acceptCount + "</property>");
            }
            if ((compression = tomcatHttps.getCompression()) != null) {
                stringBuilder.append("\n    <property name=\"compression\">" + compression + "</property>");
            }
            if ((maxKeepAliveRequests = tomcatHttps.getMaxKeepAliveRequest()) != null) {
                stringBuilder.append("\n    <property name=\"maxKeepAliveRequests\">" + maxKeepAliveRequests + "</property>");
            }
            if ((keystore = tomcatHttps.getKeystoreFile()) != null) {
                stringBuilder.append("\n    <property name=\"keystore\">" + keystore + "</property>");
            }
            if ((keystorePass = tomcatHttps.getKeystorePass()) != null) {
                stringBuilder.append("\n    <property name=\"keystorePass\">" + keystorePass + "</property>");
            }
            stringBuilder.append("\n  </factory-configuration>");
            stringBuilder.append("\n</configadmin>");
            try {
                fileOutputStream.write(stringBuilder.toString().getBytes());
            }
            catch (IOException e) {
                this.log("Cannot write " + stringBuilder.toString() + " into the output file " + httpsConnectorFile.getAbsolutePath() + " :" + e, 0);
            }
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException e) {
                this.log("Cannot close the FileOutputStream resource " + e, 0);
            }
        }
        JReplace propertyReplace = new JReplace();
        propertyReplace.setDeployableFile(TOMCAT_7_HTPP_CONNECTOR);
        if (this.httpRedirectPort != null) {
            propertyReplace.setToken("<property name=\"redirectPort\">" + this.httpRedirectPort + "</property>");
        } else {
            propertyReplace.setToken("<property name=\"redirectPort\">" + TomcatHttp.DEFAULT_REDIRECT_PORT + "</property>");
        }
        String httpsPort = tomcatHttps.getPort();
        propertyReplace.setValue("<property name=\"redirectPort\">" + httpsPort + "</property>");
        this.addTask(propertyReplace);
        this.httpRedirectPort = httpsPort;
    }

    public void addConfiguredDirector(Director dir) {
        super.addConfiguredDirector(dir, "tomcat7-server.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfiguredAjp(TomcatAjp tomcatAjp) {
        File ajpConnectorFile = new File(this.getJOnASBase(), "deploy" + File.separator + TOMCAT_7_AJP_CONNECTOR);
        FileOutputStream fileOutputStream = null;
        try {
            String acceptCount;
            String connectionTimeout;
            String enableLookups;
            String minSpareThreads;
            try {
                fileOutputStream = new FileOutputStream(ajpConnectorFile);
            }
            catch (FileNotFoundException e) {
                this.log("Cannot create file " + ajpConnectorFile.getAbsolutePath() + ": " + e, 0);
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            stringBuilder.append("\n<configadmin xmlns=\"http://jonas.ow2.org/ns/configadmin/1.0\">");
            stringBuilder.append("\n  <factory-configuration pid=\"Tomcat7AjpConnector\">");
            stringBuilder.append("\n    <property name=\"address\">localhost</property>");
            stringBuilder.append("\n    <property name=\"port\">" + tomcatAjp.getPort() + "</property>");
            String redirectPort = tomcatAjp.getRedirectPort();
            if (redirectPort == null) {
                redirectPort = TomcatAjp.DEFAULT_REDIRECT_PORT;
            }
            stringBuilder.append("\n    <property name=\"redirectPort\">" + redirectPort + "</property>");
            String maxThreads = tomcatAjp.getMaxThreads();
            if (maxThreads != null) {
                stringBuilder.append("\n    <property name=\"maxThreads\">" + maxThreads + "</property>");
            }
            if ((minSpareThreads = tomcatAjp.getMinSpareThreads()) != null) {
                stringBuilder.append("\n    <property name=\"minSpareThreads\">" + minSpareThreads + "</property>");
            }
            if ((enableLookups = tomcatAjp.getEnableLookups()) != null) {
                stringBuilder.append("\n    <property name=\"enableLookups\">" + enableLookups + "</property>");
            }
            if ((connectionTimeout = tomcatAjp.getConnectionTimeout()) != null) {
                stringBuilder.append("\n    <property name=\"connectionTimeout\">" + connectionTimeout + "</property>");
            }
            if ((acceptCount = tomcatAjp.getAcceptCount()) != null) {
                stringBuilder.append("\n    <property name=\"acceptCount\">" + acceptCount + "</property>");
            }
            stringBuilder.append("\n  </factory-configuration>");
            stringBuilder.append("\n</configadmin>");
            try {
                fileOutputStream.write(stringBuilder.toString().getBytes());
            }
            catch (IOException e) {
                this.log("Cannot write " + stringBuilder.toString() + " into the output file " + ajpConnectorFile.getAbsolutePath() + " :" + e, 0);
            }
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException e) {
                this.log("Cannot close the FileOutputStream resource " + e, 0);
            }
        }
    }

    public void execute() {
        super.execute();
        super.executeAllTask();
    }
}

