/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.datasource.deployer;

import java.io.File;
import java.io.IOException;
import org.ow2.jonas.Version;
import org.ow2.jonas.datasource.deployer.DatasourceDeployer;
import org.ow2.jonas.datasource.deployer.JonasDatasourceCleanTask;
import org.ow2.jonas.lib.work.DeployerLog;
import org.ow2.jonas.properties.ServerProperties;
import org.ow2.jonas.workcleaner.CleanTask;
import org.ow2.jonas.workcleaner.DeployerLogException;
import org.ow2.jonas.workcleaner.IDeployerLog;
import org.ow2.jonas.workcleaner.WorkCleanerService;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JonasDatasourceDeployer
extends DatasourceDeployer {
    private static Log logger = LogFactory.getLog(JonasDatasourceDeployer.class);

    public void setServerProperties(ServerProperties props) {
        this.serverProps = props;
        this.setDmRar(this.serverProps.getValue("jonas.root") + File.separator + "repositories" + File.separator + "maven2-internal" + File.separator + "org" + File.separator + "ow2" + File.separator + "jonas" + File.separator + "jonas-jca-jdbc-dm" + File.separator + Version.getNumber() + File.separator + "jonas-jca-jdbc-dm-" + Version.getNumber() + ".rar");
    }

    protected void setWorkCleanerService(WorkCleanerService workCleanerService) {
        this.initWorkingDirectory();
        File fileLog = new File(this.archiveFile.getPath() + File.separator + this.serverProps.getServerName() + ".log");
        if (!fileLog.exists()) {
            try {
                fileLog.createNewFile();
            }
            catch (IOException e) {
                logger.error((Object)("Cannot create the log file " + fileLog), new Object[0]);
            }
        }
        try {
            this.deployerLog = new DeployerLog(fileLog);
            JonasDatasourceCleanTask cleanTask = new JonasDatasourceCleanTask(this, (IDeployerLog)this.deployerLog);
            workCleanerService.registerTask((CleanTask)cleanTask);
            workCleanerService.executeTasks();
        }
        catch (DeployerLogException e) {
            logger.error((Object)"Cannot register the clean task", new Object[]{e});
        }
    }

    public void registerToDeployerManager(IDeployerManager deployerManager) {
        deployerManager.register((IDeployer)this);
        this.setDeployerManager(deployerManager);
    }

    public void unregisterfromDeployerManager(IDeployerManager deployerManager) {
        deployerManager.unregister((IDeployer)this);
    }

    public boolean isDsDeployedByWorkName(String name) {
        return this.isDeployed(name);
    }
}

