/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XMLUtils {
    private XMLUtils() {
    }

    public static String getStringValueElement(Element base, String name) {
        return XMLUtils.getStringValueElement(base, name, true);
    }

    public static String getStringValueElement(Element base, String name, boolean trim) {
        String value = null;
        NodeList list = base.getElementsByTagName(name);
        if (list.getLength() == 1) {
            Element element = (Element)list.item(0);
            Node node = element.getFirstChild();
            if (node != null) {
                value = node.getNodeValue();
            }
        } else if (list.getLength() > 1) {
            throw new IllegalStateException("Element '" + name + "' on '" + base + "' should be unique but there are '" + list.getLength() + "' elements");
        }
        if (value != null && trim) {
            value = value.trim();
        }
        return value;
    }

    public static String getAttributeValue(Element base, String name) {
        NamedNodeMap mapAttributes = base.getAttributes();
        Node node = mapAttributes.getNamedItem(name);
        if (node != null) {
            return node.getNodeValue();
        }
        return null;
    }

    public static String getStringValueElement(String ns, Element base, String name) {
        return XMLUtils.getStringValueElement(ns, base, name, true);
    }

    public static String getStringValueElement(String ns, Element base, String name, boolean trim) {
        String value = null;
        NodeList list = base.getElementsByTagNameNS(ns, name);
        if (list.getLength() == 1) {
            Element element = (Element)list.item(0);
            Node node = element.getFirstChild();
            if (node != null) {
                value = node.getNodeValue();
            }
        } else if (list.getLength() > 1) {
            throw new IllegalStateException("Element '" + name + "' on '" + base + "' should be unique but there are '" + list.getLength() + "' elements");
        }
        if (value != null && trim) {
            value = value.trim();
        }
        return value;
    }

    public static String getChildStringValueForElement(Element base, String name) {
        String value = null;
        NodeList nodeList = base.getChildNodes();
        if (nodeList.getLength() > 0) {
            int length = nodeList.getLength();
            for (int i = 0; i < length; ++i) {
                Node elNode;
                Node node = nodeList.item(i);
                if (1 != node.getNodeType() || !name.equals(node.getNodeName()) || (elNode = ((Element)node).getFirstChild()) == null) continue;
                value = elNode.getNodeValue();
                break;
            }
        }
        return value;
    }

    public static Properties getPropertiesValueElement(String ns, Element base, String name) {
        Properties returnedProperties = new Properties();
        NodeList list = base.getElementsByTagNameNS(ns, name);
        if (list.getLength() == 1) {
            Element element = (Element)list.item(0);
            NodeList properties = element.getElementsByTagNameNS(ns, "property");
            if (properties.getLength() > 0) {
                for (int i = 0; i < properties.getLength(); ++i) {
                    Element elemProperty = (Element)properties.item(i);
                    String pName = XMLUtils.getAttributeValue(elemProperty, "name");
                    String pValue = XMLUtils.getAttributeValue(elemProperty, "value");
                    if (pName == null || pValue == null) continue;
                    returnedProperties.setProperty(pName, pValue);
                }
            }
        } else if (list.getLength() > 1) {
            throw new IllegalStateException("Element '" + name + "' on '" + base + "' should be unique but there are '" + list.getLength() + "' elements");
        }
        return returnedProperties;
    }

    public static List<String> getStringListValueElement(String ns, Element base, String name) {
        ArrayList<String> returnedlist = new ArrayList<String>();
        NodeList list = base.getElementsByTagNameNS(ns, name);
        int length = list.getLength();
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                Element element = (Element)list.item(i);
                Node node = element.getFirstChild();
                if (node == null) continue;
                String value = node.getNodeValue();
                if (value != null) {
                    value = value.trim();
                }
                returnedlist.add(value);
            }
        }
        return returnedlist;
    }

    public static List<String> getStringListValueElement(Element base, String name) {
        ArrayList<String> returnedlist = new ArrayList<String>();
        NodeList list = base.getElementsByTagName(name);
        int length = list.getLength();
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                Element element = (Element)list.item(i);
                Node node = element.getFirstChild();
                if (node == null) continue;
                String value = node.getNodeValue();
                if (value != null) {
                    value = value.trim();
                }
                returnedlist.add(value);
            }
        }
        return returnedlist;
    }

    public static QName getChildValueAsQName(Element base, String name) {
        QName value = null;
        NodeList nodeList = base.getChildNodes();
        if (nodeList.getLength() > 0) {
            int length = nodeList.getLength();
            for (int i = 0; i < length; ++i) {
                Node node = nodeList.item(i);
                if (1 != node.getNodeType() || !name.equals(node.getNodeName())) continue;
                value = XMLUtils.getValueAsQName((Element)node);
            }
        }
        return value;
    }

    public static QName getValueAsQName(Element base) {
        Node node = base.getFirstChild();
        String text = null;
        if (node != null) {
            text = node.getNodeValue();
        }
        if (text == null) {
            throw new IllegalArgumentException("No QName found in the body of the tag " + base.getLocalName());
        }
        int colonIndex = text.lastIndexOf(":");
        if (colonIndex == -1) {
            return new QName(text.trim());
        }
        String namespacePrefix = text.substring(0, colonIndex);
        String localPart = text.substring(colonIndex + 1, text.length());
        String namespaceURI = base.lookupNamespaceURI(namespacePrefix);
        if (namespaceURI == null) {
            throw new IllegalArgumentException("NamespaceURI not found from prefix '" + namespacePrefix + "' for element " + base.getLocalName() + " node-value: '" + text + "'");
        }
        return new QName(namespaceURI, localPart, namespacePrefix);
    }

    public static Document newDocument(boolean namespaceAware) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(namespaceAware);
        factory.setValidating(false);
        DocumentBuilder builder = null;
        Document doc = null;
        try {
            builder = factory.newDocumentBuilder();
            doc = builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Cannot create an empty document. Note that this error should never happen!", e);
        }
        return doc;
    }
}

