/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.antmodular.jonasbase.db.base;

import java.io.File;
import java.util.AbstractMap;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.AbstractJOnASBaseAntTask;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.JTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Db
extends AbstractJOnASBaseAntTask {
    protected static final String INFO = "[DB] ";
    private static final String PORT_PROPERTY = "jonas.service.db.port";
    private static final String DB_NAME = "jonas.service.db.dbname";
    private static final String USERS = "jonas.service.db.users";
    protected static final String DB_CLASS_PROPERTY = "jonas.service.db.class";
    protected static final String DEFAULT_DATABASE = "db_jonas";
    public static final String DEFAULT_USER = "jonas";
    public static final String DEFAULT_PASSWORD = "jonas";
    protected static final String DEFAULT_HOST = "localhost";
    protected static final String DEFAULT_PORT = "9001";
    protected String portNumber = null;
    protected String dbName = null;
    protected String users = null;

    public void setPort(String portNumber) {
        this.portNumber = portNumber;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setUsers(String users) {
        this.users = users;
    }

    public String getUsers() {
        return this.users;
    }

    public AbstractMap.SimpleEntry<String, String> getFirstUsernameAndPassword() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.users.trim(), ",");
        String firstUser = null;
        if (stringTokenizer.hasMoreElements()) {
            firstUser = stringTokenizer.nextElement().toString();
        }
        if ((stringTokenizer = new StringTokenizer(firstUser.trim(), ":")).hasMoreElements()) {
            String login = stringTokenizer.nextElement().toString();
            if (stringTokenizer.hasMoreElements()) {
                String password = stringTokenizer.nextElement().toString();
                return new AbstractMap.SimpleEntry<String, String>(login, password);
            }
        }
        return new AbstractMap.SimpleEntry<String, String>("jonas", "jonas");
    }

    private void checkProperties() {
        if (this.portNumber == null) {
            throw new BuildException("[DB] Property 'portNumber' is missing.");
        }
    }

    public abstract String getUrl(String var1);

    public abstract String getClassname();

    public abstract String getMapper();

    @Override
    public void execute() {
        super.execute();
        this.checkProperties();
        String jBaseConf = this.destDir.getPath() + File.separator + "conf";
        JTask jTask = new JTask();
        jTask.setDestDir(this.destDir);
        jTask.changeValueForKey(INFO, jBaseConf, "jonas.properties", PORT_PROPERTY, this.portNumber, false);
        if (this.dbName != null) {
            jTask.changeValueForKey(INFO, jBaseConf, "jonas.properties", DB_NAME, this.dbName, false);
        }
        if (this.users != null) {
            jTask.changeValueForKey(INFO, jBaseConf, "jonas.properties", USERS, this.users, false);
        }
        this.addTask(jTask);
    }
}

