/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.antmodular.jonasbase.jms;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.AbstractJOnASBaseAntTask;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.JReplace;
import org.ow2.jonas.antmodular.jonasbase.jms.JmsRa;

public class Jms
extends AbstractJOnASBaseAntTask {
    private static final String INFO = "[JMS] ";
    private static final String DEFAULT_HOST = "localhost";
    private static final String DEFAULT_PORT = "16010";
    public static final String JORAM_CONF_FILE = "a3servers.xml";
    public static final String JORAM_ADMIN_CONF_FILE = "joramAdmin.xml";
    public static final String JORAM_ADMIN_DEPLOYABLE_FILE = "joramAdminConfig.xml";
    public static final String EOL = "\n";
    public static final String MANDATORY_DEPLOYABLE_PACKAGE = "templates/jms/joram/deploy/mandatory";
    private List<String> topics = new ArrayList<String>();
    private List<String> queues = new ArrayList<String>();

    public void setHost(String host) {
        JReplace propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile(JORAM_CONF_FILE);
        propertyReplace.setToken(DEFAULT_HOST);
        propertyReplace.setValue(host);
        propertyReplace.setLogInfo("[JMS] Setting Joram host name to : " + host + " in " + JORAM_CONF_FILE + " file.");
        this.addTask(propertyReplace);
        propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile(JORAM_ADMIN_CONF_FILE);
        propertyReplace.setToken(DEFAULT_HOST);
        propertyReplace.setValue(host);
        propertyReplace.setLogInfo("[JMS] Setting Joram host name to : " + host + " in " + JORAM_ADMIN_CONF_FILE + " file.");
        this.addTask(propertyReplace);
        propertyReplace = new JReplace();
        propertyReplace.setDeployableFile(JORAM_ADMIN_DEPLOYABLE_FILE);
        propertyReplace.setToken(DEFAULT_HOST);
        propertyReplace.setValue(host);
        propertyReplace.setLogInfo("[JMS] Setting Joram host name to : " + host + " in " + JORAM_ADMIN_DEPLOYABLE_FILE + " file.");
        this.addTask(propertyReplace);
        JmsRa jmsRa = new JmsRa();
        jmsRa.setServerHost(host);
        this.addTask(jmsRa);
    }

    public void setPort(String portNumber) {
        JReplace propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile(JORAM_CONF_FILE);
        propertyReplace.setToken(DEFAULT_PORT);
        propertyReplace.setValue(portNumber);
        propertyReplace.setLogInfo("[JMS] Setting Joram port number to : " + portNumber + " in " + JORAM_CONF_FILE + " file.");
        this.addTask(propertyReplace);
        propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile(JORAM_ADMIN_CONF_FILE);
        propertyReplace.setToken(DEFAULT_PORT);
        propertyReplace.setValue(portNumber);
        propertyReplace.setLogInfo("[JMS] Setting Joram port number to : " + portNumber + " in " + JORAM_ADMIN_CONF_FILE + " file.");
        this.addTask(propertyReplace);
        propertyReplace = new JReplace();
        propertyReplace.setDeployableFile(JORAM_ADMIN_DEPLOYABLE_FILE);
        propertyReplace.setToken(DEFAULT_PORT);
        propertyReplace.setValue(portNumber);
        propertyReplace.setLogInfo("[JMS] Setting Joram port number to : " + portNumber + " in " + JORAM_ADMIN_DEPLOYABLE_FILE + " file.");
        this.addTask(propertyReplace);
        JmsRa jmsRa = new JmsRa();
        jmsRa.setServerPort(portNumber);
        this.addTask(jmsRa);
    }

    public void setInitialTopics(String initialTopics) {
        StringTokenizer st = new StringTokenizer(initialTopics, ",");
        while (st.hasMoreTokens()) {
            this.topics.add(st.nextToken());
        }
    }

    public void setInitialQueues(String initialQueues) {
        StringTokenizer st = new StringTokenizer(initialQueues, ",");
        while (st.hasMoreTokens()) {
            this.queues.add(st.nextToken());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        this.copyTemplateDeployables(MANDATORY_DEPLOYABLE_PACKAGE);
        super.execute();
        super.executeAllTask();
        File joramConfig = new File(new File(this.getJOnASBase(), "deploy"), "joramAdminUserConfig.xml");
        FileOutputStream outputStream = null;
        try {
            try {
                outputStream = new FileOutputStream(joramConfig);
            }
            catch (FileNotFoundException e) {
                this.log("Cannot create file " + joramConfig.getAbsolutePath() + ": " + e, 0);
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            stringBuilder.append("\n<configadmin xmlns=\"http://jonas.ow2.org/ns/configadmin/1.0\">");
            ArrayList<String> names = new ArrayList<String>();
            names.addAll(this.topics);
            names.addAll(this.queues);
            for (String name : names) {
                stringBuilder.append("\n  <factory-configuration pid=\"org.objectweb.joram.client.osgi.DestinationMSF\">");
                stringBuilder.append("\n    <property name=\"adminWrapper\">ra</property>");
                stringBuilder.append("\n    <property name=\"serverId\">0</property>");
                stringBuilder.append("\n    <property name=\"name\">" + name + "</property>");
                String classname = this.topics.contains(name) ? "org.objectweb.joram.mom.dest.Topic" : "org.objectweb.joram.mom.dest.Queue";
                stringBuilder.append("\n    <property name=\"className\">" + classname + "</property>");
                stringBuilder.append("\n    <property name=\"freeReading\">true</property>");
                stringBuilder.append("\n    <property name=\"freeWriting\">true</property>");
                stringBuilder.append("\n    <property name=\"jndiName\">" + name + "</property>");
                stringBuilder.append("\n  </factory-configuration>");
            }
            stringBuilder.append("\n</configadmin>");
            try {
                outputStream.write(stringBuilder.toString().getBytes());
            }
            catch (IOException e) {
                this.log("Cannot write " + stringBuilder.toString() + " into the output file " + joramConfig.getAbsolutePath() + " :" + e, 0);
            }
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                this.log("Cannot close the FileOutputStream resource " + e, 0);
            }
        }
    }
}

