/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.ejb;

import java.util.HashMap;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.ejb.EjbRelationshipRoleDesc;
import org.ow2.jonas.deployment.ejb.xml.EjbRelation;
import org.ow2.jonas.deployment.ejb.xml.EjbRelationshipRole;
import org.ow2.jonas.deployment.ejb.xml.JonasEjbRelation;
import org.ow2.jonas.deployment.ejb.xml.JonasEjbRelationshipRole;

public class EjbRelationDesc {
    private Logger logger = null;
    private String name;
    private String name1;
    private String name2;
    private EjbRelationshipRoleDesc relationshipRoleDesc1;
    private EjbRelationshipRoleDesc relationshipRoleDesc2;
    private String jdbcTableName = null;
    private EjbRelationshipRole role1;
    private EjbRelationshipRole role2;
    JonasEjbRelation jRel = null;
    JonasEjbRelationshipRole jRsRole1 = null;
    JonasEjbRelationshipRole jRsRole2 = null;

    public EjbRelationDesc(EjbRelation er, Logger logger) throws DeploymentDescException {
        this.logger = logger;
        this.role1 = er.getEjbRelationshipRole();
        this.role2 = er.getEjbRelationshipRole2();
        String cmr1 = "";
        if (this.role1.getCmrField() != null) {
            cmr1 = this.role1.getCmrField().getCmrFieldName();
        }
        String cmr2 = "";
        if (this.role2.getCmrField() != null) {
            cmr2 = this.role2.getCmrField().getCmrFieldName();
        }
        this.name1 = this.role1.getEjbRelationshipRoleName();
        if (this.name1 == null || this.name1.length() == 0) {
            this.name1 = this.role2.getCmrField() != null ? cmr2 : "role1";
            this.role1.setEjbRelationshipRoleName(this.name1);
        }
        this.name2 = this.role2.getEjbRelationshipRoleName();
        if (this.name2 == null || this.name2.length() == 0) {
            this.name2 = this.role1.getCmrField() != null ? cmr1 : "role2";
            this.role2.setEjbRelationshipRoleName(this.name2);
        }
        if (this.name1.equals(this.name2)) {
            throw new DeploymentDescException("Relation " + this.name + " have 2 roles with same name: " + this.name1);
        }
        String ern = er.getEjbRelationName();
        this.name = ern == null || ern.length() == 0 ? cmr2 + "-" + cmr1 : ern;
    }

    public void setJonasInfo(JonasEjbRelation jer) throws DeploymentDescException {
        this.jRel = jer;
        HashMap<String, JonasEjbRelationshipRole> table = new HashMap<String, JonasEjbRelationshipRole>();
        if (this.jRel != null) {
            for (JonasEjbRelationshipRole jersr : this.jRel.getJonasEjbRelationshipRoleList()) {
                String rname = jersr.getEjbRelationshipRoleName();
                if (!rname.equals(this.name1) && !rname.equals(this.name2)) {
                    throw new DeploymentDescException("Invalid relationship-role-name \"" + rname + "\" for relation \"" + this.name + "\" in jonas-ejb-jar.xml");
                }
                table.put(rname, jersr);
            }
        }
        this.jRsRole1 = (JonasEjbRelationshipRole)table.get(this.name1);
        this.jRsRole2 = (JonasEjbRelationshipRole)table.get(this.name2);
        this.relationshipRoleDesc1 = new EjbRelationshipRoleDesc(this, this.name1, this.role1, this.jRsRole1, this.role2, true, this.logger);
        this.relationshipRoleDesc2 = new EjbRelationshipRoleDesc(this, this.name2, this.role2, this.jRsRole2, this.role1, false, this.logger);
        boolean r1hf = this.relationshipRoleDesc1.hasCmrField();
        boolean r2hf = this.relationshipRoleDesc2.hasCmrField();
        EjbRelationshipRoleDesc nocmr = null;
        EjbRelationshipRoleDesc cmr = null;
        if (r1hf && !r2hf) {
            nocmr = this.relationshipRoleDesc2;
            cmr = this.relationshipRoleDesc1;
        } else if (!r1hf && r2hf) {
            nocmr = this.relationshipRoleDesc1;
            cmr = this.relationshipRoleDesc2;
        }
        if (nocmr != null) {
            String cmrName = this.name;
            for (int i = 0; i < cmrName.length(); ++i) {
                char c = cmrName.charAt(i);
                if (Character.isJavaIdentifierPart(c)) continue;
                cmrName = cmrName.replace(c, '_');
            }
            cmrName = "jonasCMR" + cmrName;
            nocmr.setCmrFieldName(cmrName);
            nocmr.setIsJOnASCmrField();
            if (nocmr.isTargetMultiple()) {
                if (cmr.isTargetMultiple()) {
                    nocmr.setCmrFieldType(cmr.cmrFieldType.getName());
                } else {
                    nocmr.setCmrFieldType("java.util.Collection");
                }
            }
        }
    }

    protected void fillMappingInfo() throws DeploymentDescException {
        if (this.jRel != null) {
            if (this.jRel.getJdbcTableName() != null && this.jRel.getJdbcTableName().length() != 0) {
                this.jdbcTableName = this.jRel.getJdbcTableName();
            }
            this.relationshipRoleDesc1.fillMappingInfo();
            this.relationshipRoleDesc2.fillMappingInfo();
        }
    }

    protected void fillMappingInfoWithDefault() {
        if (!this.hasJdbcTable() && this.getRelationshipRole1().isTargetMultiple() && this.getRelationshipRole2().isTargetMultiple()) {
            this.jdbcTableName = this.getRelationshipRole1().getSourceBean().getAbstractSchemaName().toUpperCase() + "_" + this.getRelationshipRole2().getSourceBean().getAbstractSchemaName().toUpperCase();
        }
        if (!this.getRelationshipRole1().isSourceMultiple() && !this.getRelationshipRole2().isSourceMultiple()) {
            if (!this.getRelationshipRole1().hasJdbcMapping() && !this.getRelationshipRole2().hasJdbcMapping()) {
                if (!this.getRelationshipRole1().isJOnASCmrField() && !this.getRelationshipRole2().isJOnASCmrField()) {
                    this.getRelationshipRole1().fillMappingInfoWithDefault();
                } else if (!this.getRelationshipRole1().isJOnASCmrField()) {
                    this.getRelationshipRole1().fillMappingInfoWithDefault();
                } else {
                    this.getRelationshipRole2().fillMappingInfoWithDefault();
                }
            }
        } else if (this.getRelationshipRole1().isSourceMultiple() && this.getRelationshipRole2().isSourceMultiple()) {
            this.getRelationshipRole1().fillMappingInfoWithDefault();
            this.getRelationshipRole2().fillMappingInfoWithDefault();
        } else if (this.getRelationshipRole1().isSourceMultiple()) {
            this.getRelationshipRole1().fillMappingInfoWithDefault();
        } else {
            this.getRelationshipRole2().fillMappingInfoWithDefault();
        }
    }

    public String getName() {
        return this.name;
    }

    public EjbRelationshipRoleDesc getRelationshipRole1() {
        return this.relationshipRoleDesc1;
    }

    public EjbRelationshipRoleDesc getRelationshipRole2() {
        return this.relationshipRoleDesc2;
    }

    public boolean hasJdbcTable() {
        return this.jdbcTableName != null;
    }

    public String getJdbcTableName() {
        return this.jdbcTableName;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("\ngetName()=" + this.getName());
        if (this.hasJdbcTable()) {
            ret.append("\ngetJdbcTableName() = " + this.getJdbcTableName());
        }
        ret.append("\ngetRelationshipRole1() = " + this.getRelationshipRole1());
        ret.append("\ngetRelationshipRole2() = " + this.getRelationshipRole2());
        return ret.toString();
    }
}

