/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.ejb;

import java.lang.reflect.Method;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.xml.JLinkedList;
import org.ow2.jonas.deployment.ejb.SessionDesc;
import org.ow2.jonas.deployment.ejb.xml.AssemblyDescriptor;
import org.ow2.jonas.deployment.ejb.xml.JonasSession;
import org.ow2.jonas.deployment.ejb.xml.Session;

public class SessionStatefulDesc
extends SessionDesc {
    protected Method isModifiedMethod = null;

    public SessionStatefulDesc(ClassLoader classLoader, Session ses, AssemblyDescriptor asd, JonasSession jSes, JLinkedList jMDRList, String filename) throws DeploymentDescException {
        super(classLoader, ses, asd, jSes, jMDRList, filename);
        if (jSes.getIsModifiedMethodName() != null) {
            String mName = jSes.getIsModifiedMethodName();
            try {
                this.isModifiedMethod = this.ejbClass.getMethod(mName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                this.isModifiedMethod = null;
                throw new DeploymentDescException(mName + " is not a method of " + this.ejbClass.getName());
            }
            catch (SecurityException e) {
                throw new DeploymentDescException("Cannot use java reflexion on " + this.ejbClass.getName());
            }
        }
    }

    public Method getIsModifiedMethod() {
        if (this.isModifiedMethod == null) {
            throw new Error("No isModified method defined for bean " + this.ejbName);
        }
        return this.isModifiedMethod;
    }

    public boolean hasIsModifiedMethod() {
        return this.isModifiedMethod != null;
    }

    @Override
    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append(super.toString());
        if (this.hasIsModifiedMethod()) {
            ret.append("getIsModifiedMethod()=" + this.getIsModifiedMethod().toString());
        }
        return ret.toString();
    }
}

