/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.ow2.util.xml.DefaultErrorHandler;
import org.ow2.util.xml.DocumentParserException;
import org.ow2.util.xml.EmptyEntityResolver;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DocumentParser {
    private DocumentParser() {
    }

    public static Document getDocument(File file, boolean isValidating, EntityResolver entityResolver) throws DocumentParserException {
        if (!file.exists()) {
            throw new DocumentParserException("The file '" + file + "' does not exist");
        }
        try {
            return DocumentParser.getDocument(file.toURI().toURL(), isValidating, entityResolver);
        }
        catch (MalformedURLException e) {
            throw new DocumentParserException("Cannot build an URL for the file '" + file + "'", e);
        }
    }

    public static Document getDocument(URL url, boolean isValidating, EntityResolver entityResolver) throws DocumentParserException {
        URLConnection urlConnection = null;
        try {
            urlConnection = url.openConnection();
        }
        catch (IOException e) {
            throw new DocumentParserException("Cannot open a connection on URL '" + url + "'", e);
        }
        urlConnection.setDefaultUseCaches(false);
        try {
            return DocumentParser.getDocument(urlConnection.getInputStream(), isValidating, entityResolver);
        }
        catch (IOException e) {
            throw new DocumentParserException("Cannot build an input stream reader on URL '" + url + "'", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getDocument(InputStream stream, boolean isValidating, EntityResolver entityResolver) throws DocumentParserException {
        InputStreamReader reader = new InputStreamReader(stream);
        InputSource inputSource = new InputSource(reader);
        try {
            Document document = DocumentParser.getDocument(inputSource, isValidating, entityResolver);
            return document;
        }
        finally {
            try {
                ((Reader)reader).close();
            }
            catch (IOException e) {
                throw new DocumentParserException("Cannot close the Reader of the XML.", e);
            }
        }
    }

    public static Document getDocument(InputSource inputSource, boolean isValidating, EntityResolver entityResolver) throws DocumentParserException {
        List<String> schemaLocations = null;
        schemaLocations = Collections.singletonList("http://java.sun.com/xml/ns/persistence http://java.sun.com/xml/ns/persistence/persistence_1_0.xsd");
        return DocumentParser.getDocument(inputSource, isValidating, entityResolver, schemaLocations);
    }

    public static Document getDocument(InputSource inputSource, boolean isValidating, EntityResolver entityResolver, Collection<String> schemaLocations) throws DocumentParserException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(isValidating);
        if (isValidating) {
            factory.setIgnoringElementContentWhitespace(true);
            factory.setAttribute("http://apache.org/xml/features/validation/schema", isValidating);
            factory.setAttribute("http://apache.org/xml/features/validation/schema-full-checking", true);
        }
        if (isValidating && schemaLocations != null) {
            StringBuilder sb = new StringBuilder();
            for (String location : schemaLocations) {
                sb.append(location);
                sb.append(" ");
            }
            String value = sb.toString();
            if (!"".equals(value.trim())) {
                factory.setAttribute("http://apache.org/xml/properties/schema/external-schemaLocation", value.trim());
            }
        }
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new DocumentParserException("Cannot build a document builder", e);
        }
        builder.setErrorHandler(new DefaultErrorHandler());
        if (entityResolver == null) {
            builder.setEntityResolver(new EmptyEntityResolver());
        } else {
            builder.setEntityResolver(entityResolver);
        }
        Document document = null;
        try {
            document = builder.parse(inputSource);
        }
        catch (SAXException e) {
            throw new DocumentParserException("Cannot parse the XML InputSource.", e);
        }
        catch (IOException e) {
            throw new DocumentParserException("Cannot parse the XML InputSource.", e);
        }
        return document;
    }
}

